/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.functional;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.renderer.item.AttachmentItemRenderer;
import com.tacz.guns.client.resource.index.ClientAttachmentSkinIndex;
import com.tacz.guns.util.RenderDistance;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AttachmentRender
implements IFunctionalRenderer {
    private final BedrockGunModel bedrockGunModel;
    private final AttachmentType type;

    public AttachmentRender(BedrockGunModel bedrockGunModel, AttachmentType type) {
        this.bedrockGunModel = bedrockGunModel;
        this.type = type;
    }

    public static void renderAttachment(ItemStack attachmentItem, PoseStack poseStack, ItemDisplayContext transformType, int light, int overlay) {
        poseStack.m_85837_(0.0, -1.5, 0.0);
        Item item = attachmentItem.m_41720_();
        if (item instanceof IAttachment) {
            IAttachment iAttachment = (IAttachment)item;
            ResourceLocation attachmentId = iAttachment.getAttachmentId(attachmentItem);
            TimelessAPI.getClientAttachmentIndex(attachmentId).ifPresentOrElse(attachmentIndex -> {
                ResourceLocation skinId = iAttachment.getSkinId(attachmentItem);
                ClientAttachmentSkinIndex skinIndex = attachmentIndex.getSkinIndex(skinId);
                if (skinIndex != null) {
                    BedrockAttachmentModel model = skinIndex.getModel();
                    ResourceLocation texture = skinIndex.getTexture();
                    RenderType renderType = RenderType.m_110452_((ResourceLocation)texture);
                    model.render(poseStack, transformType, renderType, light, overlay);
                } else {
                    BedrockAttachmentModel model = attachmentIndex.getAttachmentModel();
                    ResourceLocation texture = attachmentIndex.getModelTexture();
                    if (model != null && texture != null) {
                        Pair<BedrockAttachmentModel, ResourceLocation> lodModel = attachmentIndex.getLodModel();
                        if (lodModel != null && !RenderDistance.inRenderHighPolyModelDistance(poseStack) && !transformType.m_269069_()) {
                            model = (BedrockAttachmentModel)lodModel.getLeft();
                            texture = (ResourceLocation)lodModel.getRight();
                        }
                        RenderType renderType = RenderType.m_110452_((ResourceLocation)texture);
                        model.render(poseStack, transformType, renderType, light, overlay);
                    }
                }
            }, () -> {
                MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
                VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)MissingTextureAtlasSprite.m_118071_()));
                AttachmentItemRenderer.SLOT_ATTACHMENT_MODEL.m_7695_(poseStack, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            });
        }
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer vertexBuffer, ItemDisplayContext transformType, int light, int overlay) {
        EnumMap<AttachmentType, ItemStack> currentAttachmentItem = this.bedrockGunModel.getCurrentAttachmentItem();
        ItemStack attachmentItem = currentAttachmentItem.get((Object)this.type);
        if (attachmentItem != null && !attachmentItem.m_41619_()) {
            Matrix3f normal = new Matrix3f((Matrix3fc)poseStack.m_85850_().m_252943_());
            Matrix4f pose = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            this.bedrockGunModel.delegateRender((poseStack1, vertexBuffer1, transformType1, light1, overlay1) -> {
                PoseStack poseStack2 = new PoseStack();
                poseStack2.m_85850_().m_252943_().mul((Matrix3fc)normal);
                poseStack2.m_85850_().m_252922_().mul((Matrix4fc)pose);
                AttachmentRender.renderAttachment(attachmentItem, poseStack2, transformType, light, overlay);
            });
        }
    }
}

