/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui;

import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.animation.screen.RefitTransform;
import com.tacz.guns.client.gui.components.FlatColorButton;
import com.tacz.guns.client.gui.components.refit.GunAttachmentSlot;
import com.tacz.guns.client.gui.components.refit.GunPropertyDiagrams;
import com.tacz.guns.client.gui.components.refit.IComponentTooltip;
import com.tacz.guns.client.gui.components.refit.IStackTooltip;
import com.tacz.guns.client.gui.components.refit.InventoryAttachmentSlot;
import com.tacz.guns.client.gui.components.refit.RefitTurnPageButton;
import com.tacz.guns.client.gui.components.refit.RefitUnloadButton;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessageRefitGun;
import com.tacz.guns.network.message.ClientMessageUnloadAttachment;
import com.tacz.guns.sound.SoundManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class GunRefitScreen
extends Screen {
    public static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("tacz", "textures/gui/refit_slot.png");
    public static final ResourceLocation TURN_PAGE_TEXTURE = new ResourceLocation("tacz", "textures/gui/refit_turn_page.png");
    public static final ResourceLocation UNLOAD_TEXTURE = new ResourceLocation("tacz", "textures/gui/refit_unload.png");
    public static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("tacz", "textures/gui/refit_slot_icons.png");
    public static final int ICON_UV_SIZE = 32;
    public static final int SLOT_SIZE = 18;
    private static final int INVENTORY_ATTACHMENT_SLOT_COUNT = 8;
    private static boolean HIDE_GUN_PROPERTY_DIAGRAMS = true;
    private int currentPage = 0;

    public GunRefitScreen() {
        super((Component)Component.m_237113_((String)"Gun Refit Screen"));
        RefitTransform.init();
    }

    public static int getSlotTextureXOffset(ItemStack gunItem, AttachmentType attachmentType) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return -1;
        }
        if (!iGun.allowAttachmentType(gunItem, attachmentType)) {
            return 192;
        }
        switch (attachmentType) {
            case GRIP: {
                return 0;
            }
            case LASER: {
                return 32;
            }
            case MUZZLE: {
                return 64;
            }
            case SCOPE: {
                return 96;
            }
            case STOCK: {
                return 128;
            }
            case EXTENDED_MAG: {
                return 160;
            }
        }
        return -1;
    }

    public static int getSlotsTextureWidth() {
        return 224;
    }

    public void m_7856_() {
        this.m_169413_();
        this.addAttachmentTypeButtons();
        this.addInventoryAttachmentButtons();
        if (HIDE_GUN_PROPERTY_DIAGRAMS) {
            this.m_142416_((GuiEventListener)new FlatColorButton(11, 11, 288, 16, (Component)Component.m_237115_((String)"gui.tacz.gun_refit.property_diagrams.show"), b -> this.switchHideButton()));
        } else {
            this.m_142416_((GuiEventListener)new FlatColorButton(14, 14, 12, 12, (Component)Component.m_237113_((String)"S"), b -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null || player.m_5833_()) {
                    return;
                }
                if (IGun.mainhandHoldGun((LivingEntity)player)) {
                    IClientPlayerGunOperator.fromLocalPlayer(player).fireSelect();
                    this.m_7856_();
                }
            }).setTooltips(new Component[]{Component.m_237115_((String)"gui.tacz.gun_refit.property_diagrams.fire_mode.switch")}));
            int buttonYOffset = GunPropertyDiagrams.getHidePropertyButtonYOffset();
            this.m_142416_((GuiEventListener)new FlatColorButton(11, buttonYOffset, 288, 12, (Component)Component.m_237115_((String)"gui.tacz.gun_refit.property_diagrams.hide"), b -> this.switchHideButton()));
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        super.m_88315_(graphics, mouseX, mouseY, pPartialTick);
        if (!HIDE_GUN_PROPERTY_DIAGRAMS) {
            GunPropertyDiagrams.draw(graphics, this.f_96547_, 11, 11);
        }
        this.f_169369_.stream().filter(w -> w instanceof IComponentTooltip).forEach(w -> ((IComponentTooltip)w).renderTooltip(component -> graphics.m_280666_(this.f_96547_, component, mouseX, mouseY)));
        this.f_169369_.stream().filter(w -> w instanceof IStackTooltip).forEach(w -> ((IStackTooltip)w).renderTooltip(stack -> graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY)));
    }

    public boolean m_7043_() {
        return false;
    }

    private void addInventoryAttachmentButtons() {
        LocalPlayer player = this.getMinecraft().f_91074_;
        if (RefitTransform.getCurrentTransformType() == AttachmentType.NONE || player == null) {
            return;
        }
        int startX = this.f_96543_ - 30;
        int startY = 50;
        int pageStart = this.currentPage * 8;
        int count = 0;
        int currentY = startY;
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack inventoryItem = inventory.m_8020_(i);
            IAttachment attachment = IAttachment.getIAttachmentOrNull(inventoryItem);
            IGun iGun = IGun.getIGunOrNull(player.m_21205_());
            if (attachment == null || iGun == null || attachment.getType(inventoryItem) != RefitTransform.getCurrentTransformType() || !iGun.allowAttachment(player.m_21205_(), inventoryItem) || ++count <= pageStart || count > pageStart + 8) continue;
            InventoryAttachmentSlot button = new InventoryAttachmentSlot(startX, currentY, i, inventory, b -> {
                int slotIndex = ((InventoryAttachmentSlot)b).getSlotIndex();
                SoundPlayManager.playerRefitSound(inventory.m_8020_(slotIndex), player, SoundManager.INSTALL_SOUND);
                ClientMessageRefitGun message = new ClientMessageRefitGun(slotIndex, inventory.f_35977_, RefitTransform.getCurrentTransformType());
                NetworkHandler.CHANNEL.sendToServer((Object)message);
            });
            this.m_142416_((GuiEventListener)button);
            currentY += 18;
        }
        int totalPage = (count - 1) / 8;
        RefitTurnPageButton turnPageButtonUp = new RefitTurnPageButton(startX, startY - 10, true, b -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.m_7856_();
            }
        });
        RefitTurnPageButton turnPageButtonDown = new RefitTurnPageButton(startX, startY + 144 + 2, false, b -> {
            if (this.currentPage < totalPage) {
                ++this.currentPage;
                this.m_7856_();
            }
        });
        if (this.currentPage < totalPage) {
            this.m_142416_((GuiEventListener)turnPageButtonDown);
        }
        if (this.currentPage > 0) {
            this.m_142416_((GuiEventListener)turnPageButtonUp);
        }
    }

    private void addAttachmentTypeButtons() {
        LocalPlayer player = this.getMinecraft().f_91074_;
        if (player == null) {
            return;
        }
        IGun iGun = IGun.getIGunOrNull(player.m_21205_());
        if (iGun == null) {
            return;
        }
        int startX = this.f_96543_ - 30;
        int startY = 10;
        for (AttachmentType type : AttachmentType.values()) {
            if (type == AttachmentType.NONE) continue;
            Inventory inventory = player.m_150109_();
            GunAttachmentSlot button = new GunAttachmentSlot(startX, startY, type, inventory.f_35977_, inventory, b -> {
                AttachmentType buttonType = ((GunAttachmentSlot)b).getType();
                if (!((GunAttachmentSlot)b).isAllow()) {
                    if (RefitTransform.changeRefitScreenView(AttachmentType.NONE)) {
                        this.m_7856_();
                    }
                    return;
                }
                if (RefitTransform.getCurrentTransformType() == buttonType && buttonType != AttachmentType.NONE) {
                    if (RefitTransform.changeRefitScreenView(AttachmentType.NONE)) {
                        this.m_7856_();
                    }
                    return;
                }
                if (RefitTransform.changeRefitScreenView(buttonType)) {
                    this.m_7856_();
                }
            });
            if (RefitTransform.getCurrentTransformType() == type) {
                button.setSelected(true);
                RefitUnloadButton unloadButton = new RefitUnloadButton(startX + 5, startY + 18 + 2, b -> {
                    ItemStack attachmentItem = button.getAttachmentItem();
                    if (!attachmentItem.m_41619_()) {
                        int freeSlot = inventory.m_36062_();
                        if (freeSlot != -1) {
                            SoundPlayManager.playerRefitSound(attachmentItem, player, SoundManager.UNINSTALL_SOUND);
                            ClientMessageUnloadAttachment message = new ClientMessageUnloadAttachment(inventory.f_35977_, RefitTransform.getCurrentTransformType());
                            NetworkHandler.CHANNEL.sendToServer((Object)message);
                        } else {
                            player.m_213846_((Component)Component.m_237115_((String)"gui.tacz.gun_refit.unload.no_space"));
                        }
                    }
                });
                if (!button.getAttachmentItem().m_41619_()) {
                    this.m_142416_((GuiEventListener)unloadButton);
                }
            }
            this.m_142416_((GuiEventListener)button);
            startX -= 18;
        }
    }

    private void switchHideButton() {
        HIDE_GUN_PROPERTY_DIAGRAMS = !HIDE_GUN_PROPERTY_DIAGRAMS;
        this.m_7856_();
    }
}

