/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.event.common.GunFireSelectEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessagePlayerFireSelect;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class LocalPlayerFireSelect {
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerFireSelect(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void fireSelect() {
        if (this.data.clientStateLock) {
            return;
        }
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        if (MinecraftForge.EVENT_BUS.post((Event)new GunFireSelectEvent((LivingEntity)this.player, this.player.m_21205_(), LogicalSide.CLIENT))) {
            return;
        }
        TimelessAPI.getGunDisplay(mainhandItem).ifPresent(gunIndex -> {
            SoundPlayManager.playFireSelectSound((LivingEntity)this.player, gunIndex);
            NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerFireSelect());
            if (iGun instanceof AbstractGunItem) {
                AbstractGunItem logicGun = (AbstractGunItem)iGun;
                logicGun.fireSelect(null, mainhandItem);
            }
            AttachmentPropertyManager.postChangeEvent((LivingEntity)this.player, mainhandItem);
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = gunIndex.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.trigger("fire_select");
            }
        });
    }
}

