/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessagePlayerBoltGun;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LocalPlayerBolt {
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerBolt(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void bolt() {
        if (this.data.clientStateLock) {
            return;
        }
        if (this.data.isBolting) {
            return;
        }
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        GunData gunData = TimelessAPI.getClientGunIndex(iGun.getGunId(mainhandItem)).map(ClientGunIndex::getGunData).orElse(null);
        if (gunData == null) {
            return;
        }
        TimelessAPI.getGunDisplay(mainhandItem).ifPresent(display -> {
            Bolt boltType = gunData.getBolt();
            if (boltType != Bolt.MANUAL_ACTION) {
                return;
            }
            if (iGun.hasBulletInBarrel(mainhandItem)) {
                return;
            }
            if (iGun.getCurrentAmmoCount(mainhandItem) == 0) {
                return;
            }
            this.data.lockState(IGunOperator::getSynIsBolting);
            this.data.isBolting = true;
            NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerBoltGun());
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (animationStateMachine != null) {
                SoundPlayManager.playBoltSound((LivingEntity)this.player, display);
                animationStateMachine.trigger("blot");
            }
        });
    }

    public void tickAutoBolt() {
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            this.data.isBolting = false;
            return;
        }
        IGun iGun = (IGun)item;
        this.bolt();
        if (this.data.isBolting && iGun.hasBulletInBarrel(mainhandItem)) {
            this.data.isBolting = false;
        }
    }
}

