/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.block.entity;

import com.tacz.guns.block.StatueBlock;
import com.tacz.guns.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class StatueBlockEntity
extends BlockEntity {
    public static final BlockEntityType<StatueBlockEntity> TYPE = BlockEntityType.Builder.m_155273_(StatueBlockEntity::new, (Block[])new Block[]{(Block)ModBlocks.STATUE.get()}).m_58966_(null);
    private static final String ITEM_TAG = "Item";
    private ItemStack gunItem = ItemStack.f_41583_;

    public StatueBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(TYPE, pPos, pBlockState);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState state, StatueBlockEntity statueBlockEntity) {
        if (level.m_46467_() % 100L == 0L && !statueBlockEntity.gunItem.m_41619_()) {
            Direction direction = (Direction)state.m_61143_((Property)StatueBlock.FACING);
            double x = (double)blockPos.m_123341_() + (double)direction.m_122429_() * 0.75 + 0.5;
            double z = (double)blockPos.m_123343_() + (double)direction.m_122431_() * 0.75 + 0.5;
            double dx = -0.02 + level.f_46441_.m_188500_() * 0.04;
            double dz = -0.02 + level.f_46441_.m_188500_() * 0.04;
            double dy = -0.02 + level.f_46441_.m_188500_() * 0.04;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, (double)blockPos.m_123342_() + 2.25, z, dx, dy, dz);
        }
    }

    public ItemStack getGunItem() {
        return this.gunItem;
    }

    public void setGun(ItemStack stack) {
        this.dropItem();
        this.gunItem = stack.m_41777_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
        this.m_6596_();
    }

    public void dropItem() {
        if (!this.gunItem.m_41619_() && this.f_58857_ != null) {
            Direction direction = (Direction)this.m_58900_().m_61143_((Property)StatueBlock.FACING);
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_.m_121945_(direction).m_7494_(), (ItemStack)this.gunItem);
            this.gunItem = ItemStack.f_41583_;
            if (this.f_58857_ != null) {
                BlockState state = this.f_58857_.m_8055_(this.f_58858_);
                this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            }
            this.m_6596_();
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(ITEM_TAG, 10)) {
            this.gunItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_(ITEM_TAG));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEM_TAG, (Tag)this.gunItem.m_41739_(new CompoundTag()));
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_(ITEM_TAG, (Tag)this.gunItem.m_41739_(new CompoundTag()));
        return tag;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-2, 0, -2), this.f_58858_.m_7918_(2, 2, 2));
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

