/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item;

import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.FireMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IGun {
    @Nullable
    public static IGun getIGunOrNull(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            return iGun;
        }
        return null;
    }

    public static boolean mainhandHoldGun(LivingEntity livingEntity) {
        return livingEntity.m_21205_().m_41720_() instanceof IGun;
    }

    public static FireMode getMainhandFireMode(LivingEntity livingEntity) {
        ItemStack mainhandItem = livingEntity.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            return iGun.getFireMode(mainhandItem);
        }
        return FireMode.UNKNOWN;
    }

    public float getAimingZoom(ItemStack var1);

    public boolean useDummyAmmo(ItemStack var1);

    public int getDummyAmmoAmount(ItemStack var1);

    public void setDummyAmmoAmount(ItemStack var1, int var2);

    public void addDummyAmmoAmount(ItemStack var1, int var2);

    public boolean hasMaxDummyAmmo(ItemStack var1);

    public int getMaxDummyAmmoAmount(ItemStack var1);

    public void setMaxDummyAmmoAmount(ItemStack var1, int var2);

    public boolean hasAttachmentLock(ItemStack var1);

    public void setAttachmentLock(ItemStack var1, boolean var2);

    @NotNull
    public ResourceLocation getGunId(ItemStack var1);

    public void setGunId(ItemStack var1, @Nullable ResourceLocation var2);

    @NotNull
    public ResourceLocation getGunDisplayId(ItemStack var1);

    public void setGunDisplayId(ItemStack var1, @Nullable ResourceLocation var2);

    public int getLevel(int var1);

    public int getExp(int var1);

    public int getMaxLevel();

    public int getLevel(ItemStack var1);

    public int getExp(ItemStack var1);

    public int getExpToNextLevel(ItemStack var1);

    public int getExpCurrentLevel(ItemStack var1);

    public FireMode getFireMode(ItemStack var1);

    public void setFireMode(ItemStack var1, @Nullable FireMode var2);

    public int getCurrentAmmoCount(ItemStack var1);

    public void setCurrentAmmoCount(ItemStack var1, int var2);

    public void reduceCurrentAmmoCount(ItemStack var1);

    public void dropAllAmmo(Player var1, ItemStack var2);

    @Nonnull
    public ItemStack getAttachment(ItemStack var1, AttachmentType var2);

    @Nonnull
    public ItemStack getBuiltinAttachment(ItemStack var1, AttachmentType var2);

    @Nullable
    public CompoundTag getAttachmentTag(ItemStack var1, AttachmentType var2);

    @Nonnull
    public ResourceLocation getBuiltInAttachmentId(ItemStack var1, AttachmentType var2);

    @Nonnull
    public ResourceLocation getAttachmentId(ItemStack var1, AttachmentType var2);

    public void installAttachment(@Nonnull ItemStack var1, @Nonnull ItemStack var2);

    public void unloadAttachment(@Nonnull ItemStack var1, AttachmentType var2);

    public boolean allowAttachment(ItemStack var1, ItemStack var2);

    public boolean allowAttachmentType(ItemStack var1, AttachmentType var2);

    public boolean hasBulletInBarrel(ItemStack var1);

    public void setBulletInBarrel(ItemStack var1, boolean var2);
}

