/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.event.common;

import com.tacz.guns.api.event.common.GunDamageSourcePart;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.tuple.Pair;

public class EntityKillByGunEvent
extends Event {
    private final Entity bullet;
    @Nullable
    private final LivingEntity killedEntity;
    @Nullable
    private final LivingEntity attacker;
    private final ResourceLocation gunId;
    private final ResourceLocation gunDisplayId;
    private final float baseDamage;
    private final DamageSource nonApPartDamageSource;
    private final DamageSource apPartDamageSource;
    private final boolean isHeadShot;
    private final float headshotMultiplier;
    private final LogicalSide logicalSide;

    public EntityKillByGunEvent(Entity bullet, @Nullable LivingEntity hurtEntity, @Nullable LivingEntity attacker, ResourceLocation gunId, ResourceLocation gunDisplayId, float baseDamage, @Nullable Pair<DamageSource, DamageSource> sources, boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
        this.bullet = bullet;
        this.killedEntity = hurtEntity;
        this.attacker = attacker;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
        this.baseDamage = baseDamage;
        this.nonApPartDamageSource = Optional.ofNullable(sources).map(Pair::getLeft).orElse(null);
        this.apPartDamageSource = Optional.ofNullable(sources).map(Pair::getRight).orElse(null);
        this.isHeadShot = isHeadShot;
        this.headshotMultiplier = headshotMultiplier;
        this.logicalSide = logicalSide;
    }

    public Entity getBullet() {
        return this.bullet;
    }

    @Nullable
    public LivingEntity getKilledEntity() {
        return this.killedEntity;
    }

    @Nullable
    public LivingEntity getAttacker() {
        return this.attacker;
    }

    public ResourceLocation getGunId() {
        return this.gunId;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public DamageSource getDamageSource(GunDamageSourcePart part) {
        if (this.logicalSide.isClient()) {
            throw new UnsupportedOperationException("DamageSource about gun hit is not available on client side!");
        }
        return part == GunDamageSourcePart.ARMOR_PIERCING ? this.apPartDamageSource : this.nonApPartDamageSource;
    }

    public boolean isHeadShot() {
        return this.isHeadShot;
    }

    public float getHeadshotMultiplier() {
        return this.headshotMultiplier;
    }

    public LogicalSide getLogicalSide() {
        return this.logicalSide;
    }

    public ResourceLocation getGunDisplayId() {
        return this.gunDisplayId;
    }
}

