/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.network.GeckoLibNetwork;

public class StopTriggeredSingletonAnimPacket {
    private final String syncableId;
    private final long instanceId;
    private final String controllerName;
    private final String animName;

    public StopTriggeredSingletonAnimPacket(String syncableId, long instanceId, @Nullable String controllerName, String animName) {
        this.syncableId = syncableId;
        this.instanceId = instanceId;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.syncableId);
        buffer.m_130103_(this.instanceId);
        buffer.m_130070_(this.controllerName);
        buffer.m_130070_(this.animName);
    }

    public static StopTriggeredSingletonAnimPacket decode(FriendlyByteBuf buffer) {
        return new StopTriggeredSingletonAnimPacket(buffer.m_130277_(), buffer.m_130258_(), buffer.m_130277_(), buffer.m_130277_());
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            AnimatableManager manager;
            GeoAnimatable animatable = GeckoLibNetwork.getSyncedAnimatable(this.syncableId);
            if (animatable != null && (manager = animatable.getAnimatableInstanceCache().getManagerForId(this.instanceId)) != null) {
                manager.stopTriggeredAnimation(this.controllerName, this.animName);
            }
        });
        handler.setPacketHandled(true);
    }
}

