/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.object.DataTicket;

public abstract class SerializableDataTicket<D>
extends DataTicket<D> {
    public SerializableDataTicket(String id, Class<? extends D> objectType) {
        super(id, objectType);
    }

    public abstract void encode(D var1, FriendlyByteBuf var2);

    public abstract D decode(FriendlyByteBuf var1);

    public static SerializableDataTicket<Double> ofDouble(ResourceLocation id) {
        return new SerializableDataTicket<Double>(id.toString(), Double.class){

            @Override
            public void encode(Double data, FriendlyByteBuf buffer) {
                buffer.writeDouble(data.doubleValue());
            }

            @Override
            public Double decode(FriendlyByteBuf buffer) {
                return buffer.readDouble();
            }
        };
    }

    public static SerializableDataTicket<Float> ofFloat(ResourceLocation id) {
        return new SerializableDataTicket<Float>(id.toString(), Float.class){

            @Override
            public void encode(Float data, FriendlyByteBuf buffer) {
                buffer.writeFloat(data.floatValue());
            }

            @Override
            public Float decode(FriendlyByteBuf buffer) {
                return Float.valueOf(buffer.readFloat());
            }
        };
    }

    public static SerializableDataTicket<Boolean> ofBoolean(ResourceLocation id) {
        return new SerializableDataTicket<Boolean>(id.toString(), Boolean.class){

            @Override
            public void encode(Boolean data, FriendlyByteBuf buffer) {
                buffer.writeBoolean(data.booleanValue());
            }

            @Override
            public Boolean decode(FriendlyByteBuf buffer) {
                return buffer.readBoolean();
            }
        };
    }

    public static SerializableDataTicket<Integer> ofInt(ResourceLocation id) {
        return new SerializableDataTicket<Integer>(id.toString(), Integer.class){

            @Override
            public void encode(Integer data, FriendlyByteBuf buffer) {
                buffer.m_130130_(data.intValue());
            }

            @Override
            public Integer decode(FriendlyByteBuf buffer) {
                return buffer.m_130242_();
            }
        };
    }

    public static SerializableDataTicket<String> ofString(ResourceLocation id) {
        return new SerializableDataTicket<String>(id.toString(), String.class){

            @Override
            public void encode(String data, FriendlyByteBuf buffer) {
                buffer.m_130070_(data);
            }

            @Override
            public String decode(FriendlyByteBuf buffer) {
                return buffer.m_130277_();
            }
        };
    }

    public static <E extends Enum<E>> SerializableDataTicket<E> ofEnum(ResourceLocation id, final Class<E> enumClass) {
        return new SerializableDataTicket<E>(id.toString(), enumClass){

            @Override
            public void encode(E data, FriendlyByteBuf buffer) {
                buffer.m_130070_(((Enum)data).toString());
            }

            @Override
            public E decode(FriendlyByteBuf buffer) {
                return Enum.valueOf(enumClass, buffer.m_130277_());
            }
        };
    }
}

