/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bs.content;

import com.tterrag.registrate.util.entry.BlockEntityEntry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import uwu.lopyluna.create_bs.content.TierMaterials;

public class TieredBEBlockList<T extends BlockEntity>
implements Iterable<BlockEntityEntry<T>> {
    private static final int AMOUNT = TierMaterials.values().length;
    private final BlockEntityEntry<?>[] values = new BlockEntityEntry[AMOUNT];

    public TieredBEBlockList(Function<TierMaterials, BlockEntityEntry<? extends T>> filler) {
        for (TierMaterials tier : TierMaterials.values()) {
            this.values[tier.ordinal()] = filler.apply(tier);
        }
    }

    public BlockEntityEntry<T> get(TierMaterials tier) {
        return this.values[tier.ordinal()];
    }

    @Override
    @NotNull
    public Iterator<BlockEntityEntry<T>> iterator() {
        return new Iterator<BlockEntityEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < TieredBEBlockList.this.values.length;
            }

            @Override
            public BlockEntityEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return TieredBEBlockList.this.values[this.index++];
            }
        };
    }
}

