/*
 * Decompiled with CFR 0.152.
 */
package youyihj.hotai.transformers;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import youyihj.hotai.HotaiTransformationService;

public abstract class HotaiTransformer<T>
implements ITransformer<ClassNode> {
    private final Map<String, T> transformations;

    public HotaiTransformer(Map<String, T> transformations) {
        this.transformations = transformations;
    }

    public final ClassNode transform(ClassNode classNode, ITransformerVotingContext iTransformerVotingContext) {
        ClassNode dest = new ClassNode();
        ClassWriter src = new ClassWriter(0);
        classNode.accept((ClassVisitor)src);
        new ClassReader(this.transform(src.toByteArray(), this.transformations.get(classNode.name), classNode.name)).accept((ClassVisitor)dest, 0);
        HotaiTransformationService.LOGGER.info("Patched class: {}", (Object)classNode.name);
        return dest;
    }

    @NotNull
    public final TransformerVoteResult castVote(ITransformerVotingContext iTransformerVotingContext) {
        return TransformerVoteResult.YES;
    }

    @NotNull
    public final Set<ITransformer.Target> targets() {
        return this.transformations.keySet().stream().map(ITransformer.Target::targetClass).collect(Collectors.toSet());
    }

    protected abstract byte[] transform(byte[] var1, T var2, String var3);
}

