/*
 * Decompiled with CFR 0.152.
 */
package youyihj.hotai;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.badiff.Diff;
import org.badiff.imp.MemoryDiff;
import org.badiff.io.DefaultSerialization;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import youyihj.hotai.transformers.BytecodeTransformer;
import youyihj.hotai.transformers.DiffTransformer;

public class HotaiTransformationService
implements ITransformationService {
    private final Map<String, Diff> transformedDiffes = new ConcurrentHashMap<String, Diff>();
    private final Map<String, byte[]> transformedClasses = new ConcurrentHashMap<String, byte[]>();
    private Path hotaiPath;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Hotai");

    @NotNull
    public String name() {
        return "hotai";
    }

    public void initialize(IEnvironment environment) {
        LOGGER.info("Reading patched classes");
        Optional gamePath = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get());
        gamePath.ifPresentOrElse(it -> {
            this.hotaiPath = it.resolve("hotai");
            if (!Files.exists(this.hotaiPath, new LinkOption[0])) {
                try {
                    Files.createDirectory(this.hotaiPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to create hotai dir", (Throwable)e);
                }
            }
            try {
                Files.walkFileTree(this.hotaiPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.toString().endsWith(".class")) {
                            HotaiTransformationService.this.transformedClasses.put(HotaiTransformationService.this.getClassName(file, ".class"), Files.readAllBytes(file));
                        }
                        if (file.toString().endsWith(".badiff")) {
                            MemoryDiff diff = new MemoryDiff();
                            diff.deserialize(DefaultSerialization.newInstance(), Files.newInputStream(file, new OpenOption[0]));
                            HotaiTransformationService.this.transformedDiffes.put(HotaiTransformationService.this.getClassName(file, ".badiff"), diff);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("Could not read class files", (Throwable)e);
            }
        }, () -> LOGGER.error("Could not find game path"));
    }

    public void onLoad(IEnvironment environment, Set<String> otherServices) throws IncompatibleEnvironmentException {
    }

    @NotNull
    public List<ITransformer> transformers() {
        return List.of(new BytecodeTransformer(this.hotaiPath, this.transformedClasses), new DiffTransformer(this.transformedDiffes));
    }

    private String getClassName(Path file, String extension) {
        String fileName = this.hotaiPath.relativize(file).toString();
        return fileName.substring(0, fileName.length() - extension.length()).replace(file.getFileSystem().getSeparator(), "/");
    }
}

