/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.badiff.io.DataInputInputStream;
import org.badiff.io.DataOutputOutputStream;

public class Streams {
    public static long copy(InputStream in, OutputStream out) throws IOException {
        long count = 0L;
        byte[] buf = new byte[8192];
        int r = in.read(buf);
        while (r != -1) {
            out.write(buf, 0, r);
            count += (long)r;
            r = in.read(buf);
        }
        return count;
    }

    public static long copy(InputStream in, OutputStream out, long length) throws IOException {
        long count = 0L;
        byte[] buf = new byte[8192];
        int r = in.read(buf, 0, (int)Math.min((long)buf.length, length - count));
        while (r != -1) {
            out.write(buf, 0, r);
            if ((count += (long)r) == length) break;
            r = in.read(buf, 0, (int)Math.min((long)buf.length, length - count));
        }
        return count;
    }

    public static OutputStream asStream(DataOutput out) {
        if (out instanceof OutputStream) {
            return (OutputStream)((Object)out);
        }
        return new DataOutputOutputStream(out);
    }

    public static InputStream asStream(DataInput in) {
        if (in instanceof InputStream) {
            return (InputStream)((Object)in);
        }
        return new DataInputInputStream(in);
    }

    private Streams() {
    }
}

