/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.util;

public class Integers {
    public static long negative(long l) {
        return l >> 63;
    }

    public static int negative(int i) {
        return i >> 31;
    }

    public static short netative(short s) {
        return (short)Integers.negative(s);
    }

    public static long min(long lhs, long rhs) {
        long m = Integers.negative(lhs - rhs);
        return lhs & m | rhs & (m ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int min(int lhs, int rhs) {
        int m = Integers.negative(lhs - rhs);
        return lhs & m | rhs & ~m;
    }

    public static short min(short lhs, short rhs) {
        return (short)Integers.min((int)lhs, (int)rhs);
    }

    public static long max(long lhs, long rhs) {
        long m = Integers.negative(lhs - rhs);
        return lhs & (m ^ 0xFFFFFFFFFFFFFFFFL) | rhs & m;
    }

    public static int max(int lhs, int rhs) {
        int m = Integers.negative(lhs - rhs);
        return lhs & ~m | rhs & m;
    }

    public static short max(short lhs, short rhs) {
        return (short)Integers.max((int)lhs, (int)rhs);
    }

    public static long any(long l) {
        l = l | l << 32 | l >>> 32;
        l = l | l << 16 | l >>> 16;
        l = l | l << 8 | l >>> 8;
        l = l | l << 4 | l >>> 4;
        l = l | l << 2 | l >>> 2;
        l = l | l << 1 | l >>> 1;
        return l;
    }

    public static int any(int i) {
        return (int)Integers.any((long)i);
    }

    public static short any(short s) {
        return (short)Integers.any((long)s);
    }

    public static long all(long l) {
        long c = Long.bitCount(l);
        return Integers.any(c ^ 0x40L) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static int all(int n) {
        long l = n;
        l |= l << 32;
        return (int)Integers.all(l);
    }

    public static short all(short s) {
        long l = s;
        l |= l << 32;
        l |= l << 16;
        return (short)Integers.all(l);
    }

    public static long cmp(long lhs, long rhs, long equal, long unequal) {
        long mask = Integers.negative(lhs - rhs) | Integers.negative(rhs - lhs);
        return equal & (mask ^ 0xFFFFFFFFFFFFFFFFL) | unequal & mask;
    }

    public static int cmp(long lhs, long rhs, int equal, int unequal) {
        long mask = Integers.negative(lhs - rhs) | Integers.negative(rhs - lhs);
        return (int)((long)equal & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)unequal & mask);
    }

    public static short cmp(long lhs, long rhs, short equal, short unequal) {
        return (short)Integers.cmp(lhs, rhs, (int)equal, (int)unequal);
    }

    private Integers() {
    }
}

