/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.badiff.io.NoopOutputStream;
import org.badiff.io.RandomInput;
import org.badiff.io.RandomInputStream;
import org.badiff.util.Streams;

public class Digests {
    public static final String DEFAULT_ALGORITHM = "SHA-1";

    public static byte[] defaultZeroes() {
        return new byte[Digests.defaultDigest().digest().length];
    }

    public static MessageDigest defaultDigest() {
        try {
            return MessageDigest.getInstance(DEFAULT_ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Could not find SHA-1");
        }
    }

    public static MessageDigest digest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    public static byte[] digest(File file, MessageDigest digest) throws IOException {
        DigestInputStream digin = new DigestInputStream(new FileInputStream(file), digest);
        Streams.copy(digin, new NoopOutputStream());
        digin.close();
        return digin.getMessageDigest().digest();
    }

    public static byte[] digest(RandomInput input, MessageDigest digest) throws IOException {
        DigestInputStream digin = new DigestInputStream(new RandomInputStream(input), digest);
        Streams.copy(digin, new NoopOutputStream());
        return digin.getMessageDigest().digest();
    }

    public static String pretty(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", 0xFF & b));
        }
        return sb.toString();
    }

    public static byte[] parse(String pretty) {
        if (pretty.length() % 2 == 1) {
            throw new IllegalArgumentException("odd number of hex chars");
        }
        byte[] buf = new byte[pretty.length() / 2];
        for (int i = 0; i < pretty.length() - 1; i += 2) {
            buf[i / 2] = (byte)Integer.parseInt(pretty.substring(i, i + 2), 16);
        }
        return buf;
    }

    private Digests() {
    }
}

