/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.badiff.Applyable;
import org.badiff.imp.BadiffFileDiff;
import org.badiff.io.RandomInputStream;
import org.badiff.io.RuntimeIOException;
import org.badiff.q.OpQueue;
import org.badiff.q.ReplaceOpQueue;
import org.badiff.q.StreamChunkingOpQueue;

public class Diffs {
    public static OpQueue queue(byte[] orig, byte[] target) {
        return new ReplaceOpQueue(orig, target);
    }

    public static OpQueue queue(InputStream orig, InputStream target) {
        return new StreamChunkingOpQueue(orig, target);
    }

    public static OpQueue improved(OpQueue q) {
        return BadiffFileDiff.PIPE.from(q).outlet();
    }

    public static byte[] apply(Applyable a, byte[] orig) {
        RandomInputStream in = new RandomInputStream(orig);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            a.apply(in, out);
            if (((InputStream)in).available() > 0) {
                throw new IOException("Not all byts consumed from byte[]");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void apply(Applyable a, File orig, File target) throws IOException {
        RandomInputStream in = new RandomInputStream(orig);
        try {
            FileOutputStream out = new FileOutputStream(target);
            try {
                a.apply(in, out);
            }
            finally {
                out.close();
            }
        }
        finally {
            if (((InputStream)in).available() > 0) {
                throw new IOException("Not all input data consumed:" + orig);
            }
            ((InputStream)in).close();
        }
    }

    private Diffs() {
    }
}

