/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.q;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.badiff.Op;
import org.badiff.q.FilterOpQueue;
import org.badiff.q.OpQueue;

public class RewindingOpQueue
extends FilterOpQueue {
    protected int maxkeys;
    protected int minlength;
    protected long lookbehind;
    protected long pos;
    protected TreeMap<Long, byte[]> deletes = new TreeMap();

    public RewindingOpQueue(OpQueue source) {
        this(source, 0x100000L);
    }

    public RewindingOpQueue(OpQueue source, long lookbehind) {
        this(source, lookbehind, 16);
    }

    public RewindingOpQueue(OpQueue source, long lookbehind, int minlength) {
        this(source, lookbehind, minlength, 1024);
    }

    public RewindingOpQueue(OpQueue source, long lookbehind, int minlength, int maxkeys) {
        super(source);
        this.lookbehind = lookbehind;
        this.minlength = minlength;
        this.maxkeys = maxkeys;
    }

    @Override
    protected boolean pull() {
        if (!this.require(1)) {
            return this.flush();
        }
        Op e = (Op)this.filtering.remove(0);
        switch (e.getOp()) {
            case 3: {
                this.pos += (long)e.getRun();
                this.deletes.subMap(Long.MIN_VALUE, this.pos - this.lookbehind).clear();
                this.prepare(e);
                return true;
            }
            case 1: {
                if (e.getData() != null && e.getData().length >= this.minlength) {
                    this.deletes.put(this.pos, e.getData());
                    this.deletes.subMap(Long.MIN_VALUE, this.pos - this.lookbehind).clear();
                    while (this.deletes.size() > this.maxkeys) {
                        this.deletes.remove(this.deletes.firstKey());
                    }
                }
                this.pos += (long)e.getRun();
                this.prepare(e);
                return true;
            }
            case 2: {
                long dpos = -1L;
                if (e.getData().length >= this.minlength) {
                    for (Map.Entry<Long, byte[]> en : this.deletes.entrySet()) {
                        if (!Arrays.equals(e.getData(), en.getValue())) continue;
                        dpos = en.getKey();
                        break;
                    }
                }
                if (dpos == -1L) {
                    this.prepare(e);
                    return true;
                }
                this.prepare(new Op(1, (int)(dpos - this.pos), null));
                this.prepare(new Op(3, e.getRun(), null));
                this.prepare(new Op(1, (int)(-(dpos - this.pos) - (long)e.getRun()), null));
                return true;
            }
        }
        return false;
    }
}

