/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.q;

import java.io.IOException;
import java.util.Arrays;
import org.badiff.Op;
import org.badiff.io.RandomInput;
import org.badiff.io.RuntimeIOException;
import org.badiff.q.OpQueue;

public class RandomChunkingOpQueue
extends OpQueue {
    protected RandomInput orig;
    protected RandomInput target;
    protected int chunk;

    public RandomChunkingOpQueue(RandomInput orig, RandomInput target) {
        this(orig, target, 2048);
    }

    public RandomChunkingOpQueue(RandomInput orig, RandomInput target, int chunk) {
        this.orig = orig;
        this.target = target;
        this.chunk = chunk;
    }

    @Override
    protected boolean pull() {
        byte[] obuf = this.readChunk(this.orig);
        byte[] tbuf = this.readChunk(this.target);
        if (obuf != null) {
            this.prepare(new Op(1, obuf.length, obuf));
        }
        if (tbuf != null) {
            this.prepare(new Op(2, tbuf.length, tbuf));
        }
        return obuf != null || tbuf != null;
    }

    protected byte[] readChunk(RandomInput in) {
        try {
            byte[] buf = new byte[this.chunk];
            int r = in.read(buf);
            if (r == -1) {
                return null;
            }
            if (r == this.chunk) {
                return buf;
            }
            return Arrays.copyOf(buf, r);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }
}

