/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.q;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.badiff.Op;
import org.badiff.alg.Graph;
import org.badiff.alg.GraphFactory;
import org.badiff.q.ChainOpQueue;
import org.badiff.q.FilterOpQueue;
import org.badiff.q.FutureOpQueue;
import org.badiff.q.GraphOpQueue;
import org.badiff.q.ListOpQueue;
import org.badiff.q.OpQueue;
import org.badiff.q.ReplaceOpQueue;

public class ParallelGraphOpQueue
extends FilterOpQueue {
    public static final GraphFactory EDIT_GRAPH = GraphFactory.EDIT_GRAPH;
    public static final GraphFactory INERTIAL_GRAPH = GraphFactory.INERTIAL_GRAPH;
    public static final GraphFactory ADJUSTABLE_GRAPH = GraphFactory.ADJUSTABLE_GRAPH;
    private static final GraphFactory DEFAULT_GRAPH = GraphFactory.INERTIAL_GRAPH;
    protected OpQueue input;
    protected int chunk;
    protected ExecutorService pool;
    protected int workers;
    protected ChainOpQueue chain;
    protected GraphFactory graphFactory;
    protected AtomicInteger tasks = new AtomicInteger(0);
    protected ThreadLocal<Graph> graphs = new ThreadLocal<Graph>(){

        @Override
        protected Graph initialValue() {
            return ParallelGraphOpQueue.this.graphFactory.newGraph((ParallelGraphOpQueue.this.chunk + 1) * (ParallelGraphOpQueue.this.chunk + 1));
        }
    };

    public ParallelGraphOpQueue(OpQueue source) {
        this(source, Runtime.getRuntime().availableProcessors(), 2048, DEFAULT_GRAPH);
    }

    public ParallelGraphOpQueue(OpQueue source, GraphFactory graphFactory) {
        this(source, Runtime.getRuntime().availableProcessors(), 2048, graphFactory);
    }

    public ParallelGraphOpQueue(OpQueue source, int workers, int chunk, GraphFactory graphFactory) {
        super(new ChainOpQueue(new OpQueue[0]));
        this.input = source;
        this.chunk = chunk;
        this.workers = workers;
        this.graphFactory = graphFactory;
        this.pool = new ThreadPoolExecutor(workers, workers, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, ParallelGraphOpQueue.this.toString());
                t.setDaemon(true);
                return t;
            }
        });
        this.chain = (ChainOpQueue)this.source;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " <- " + this.input;
    }

    @Override
    public boolean offer(Op e) {
        return this.input.offer(e);
    }

    @Override
    protected boolean require(int count) {
        while (this.filtering.size() < count) {
            Op e = this.input.poll();
            if (e == null) {
                return false;
            }
            this.filtering.add(e);
        }
        return true;
    }

    @Override
    protected void prepare(Op e) {
        this.chain.offer(e);
    }

    protected void prepare(Future<OpQueue> f) {
        this.chain.offer(new FutureOpQueue(f));
        this.chain.offer(new OpQueue());
    }

    protected Callable<OpQueue> newTask(final Op delete, final Op insert) {
        return new Callable<OpQueue>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OpQueue call() throws Exception {
                try {
                    OpQueue graphed = new ReplaceOpQueue(delete.getData(), insert.getData());
                    graphed = new GraphOpQueue(graphed, ParallelGraphOpQueue.this.graphs.get());
                    OpQueue opQueue = graphed = new ListOpQueue(graphed);
                    return opQueue;
                }
                finally {
                    ParallelGraphOpQueue.this.tasks.decrementAndGet();
                }
            }
        };
    }

    @Override
    public Op poll() {
        this.pump();
        return super.poll();
    }

    protected void pump() {
        if (this.require(2)) {
            while (this.require(2) && this.tasks.get() < this.workers) {
                Op insert;
                Op delete;
                if (((Op)this.filtering.get(0)).getOp() == 1 && ((Op)this.filtering.get(1)).getOp() == 2) {
                    delete = (Op)this.filtering.remove(0);
                    insert = (Op)this.filtering.remove(0);
                } else if (((Op)this.filtering.get(0)).getOp() == 2 && ((Op)this.filtering.get(1)).getOp() == 1) {
                    insert = (Op)this.filtering.remove(0);
                    delete = (Op)this.filtering.remove(0);
                } else {
                    this.prepare((Op)this.filtering.remove(0));
                    continue;
                }
                this.tasks.incrementAndGet();
                this.prepare(this.pool.submit(this.newTask(delete, insert)));
            }
            if (!this.require(2)) {
                this.flush();
                this.pool.shutdown();
            }
        } else {
            this.flush();
        }
    }

    @Override
    protected boolean pull() {
        this.pump();
        Op e = this.chain.poll();
        if (e != null) {
            super.prepare(e);
        }
        return e != null;
    }
}

