/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.q;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.badiff.Applyable;
import org.badiff.Diff;
import org.badiff.Op;

public class OpQueue
implements Applyable,
Iterator<Op> {
    protected Op iterNext;
    protected Deque<Op> prepared = new ArrayDeque<Op>();

    public Op poll() {
        Op e = this.prepared.pollFirst();
        if (e == null) {
            this.pull();
            e = this.prepared.pollFirst();
        }
        return e;
    }

    public boolean offer(Op e) {
        return this.prepared.offerLast(e);
    }

    public void drain() {
        Op e = this.poll();
        while (e != null) {
            e = this.poll();
        }
    }

    public <T extends List<Op>> T drainTo(T c) {
        Op e = this.poll();
        while (e != null) {
            c.add((Op)e);
            e = this.poll();
        }
        return c;
    }

    public <T extends OpQueue> T drainTo(T q) {
        Op e = this.poll();
        while (e != null) {
            q.offer(e);
            e = this.poll();
        }
        return q;
    }

    public <T extends Diff> T drainTo(T diff) throws IOException {
        diff.store(this);
        return diff;
    }

    protected boolean pull() {
        return false;
    }

    protected void prepare(Op e) {
        this.prepared.offerLast(e);
    }

    @Override
    public void apply(InputStream orig, OutputStream target) throws IOException {
        Op e = this.poll();
        while (e != null) {
            e.apply(orig, target);
            e = this.poll();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.iterNext == null) {
            this.iterNext = this.poll();
        }
        return this.iterNext != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Op next() {
        if (this.iterNext == null) {
            this.iterNext = this.poll();
        }
        try {
            Op op = this.iterNext;
            return op;
        }
        finally {
            this.iterNext = null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String consummerize() {
        StringBuilder sb = new StringBuilder();
        Op e = this.poll();
        while (e != null) {
            sb.append(e);
            e = this.poll();
        }
        sb.append(new Op(0, 1, null));
        return sb.toString();
    }
}

