/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.q;

import org.badiff.Op;
import org.badiff.q.FilterOpQueue;
import org.badiff.q.OpQueue;

public class ChunkingOpQueue
extends FilterOpQueue {
    protected int chunk;

    public ChunkingOpQueue(OpQueue source) {
        this(source, 2048);
    }

    public ChunkingOpQueue(OpQueue source, int chunk) {
        super(source);
        this.chunk = chunk;
    }

    @Override
    protected boolean pull() {
        if (!this.require(2)) {
            return this.flush();
        }
        if (((Op)this.filtering.get(0)).getOp() != 1 || ((Op)this.filtering.get(1)).getOp() != 2) {
            return this.flush();
        }
        Op delete = (Op)this.filtering.get(0);
        Op insert = (Op)this.filtering.get(1);
        this.filtering.remove(1);
        this.filtering.remove(0);
        byte[] ddata = delete.getData();
        byte[] idata = insert.getData();
        int dpos = 0;
        int ipos = 0;
        while (dpos < ddata.length || ipos < idata.length) {
            byte[] data;
            if (dpos < ddata.length) {
                data = new byte[Math.min(this.chunk, ddata.length - dpos)];
                System.arraycopy(ddata, dpos, data, 0, data.length);
                this.prepare(new Op(1, data.length, data));
                dpos += data.length;
            }
            if (ipos >= idata.length) continue;
            data = new byte[Math.min(this.chunk, idata.length - ipos)];
            System.arraycopy(idata, ipos, data, 0, data.length);
            this.prepare(new Op(2, data.length, data));
            ipos += data.length;
        }
        return true;
    }
}

