/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.badiff.io.PushbufferInputStream;
import org.badiff.io.RandomInput;

public class StreamRandomInput
implements RandomInput {
    protected PushbufferInputStream pin;
    protected DataInputStream din;

    public StreamRandomInput(InputStream in, int size) {
        this.pin = new PushbufferInputStream(in, size);
        this.din = new DataInputStream(this.pin);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.din.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.din.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.pin.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.din.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.din.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.din.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.din.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.din.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.din.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.din.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.din.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.din.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.din.readDouble();
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.din.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.din.readUTF();
    }

    @Override
    public long first() {
        return this.pin.first();
    }

    @Override
    public long last() {
        return Long.MAX_VALUE;
    }

    @Override
    public long position() {
        return this.pin.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.pin.position(pos);
    }

    @Override
    public long skip(long count) throws IOException {
        return this.pin.skip(count);
    }

    @Override
    public int read() throws IOException {
        return this.din.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.din.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.din.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        return this.pin.available();
    }

    @Override
    public void close() throws IOException {
        this.pin.close();
    }
}

