/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.badiff.io.ByteBufferRandomInput;
import org.badiff.io.FileRandomInput;
import org.badiff.io.Random;
import org.badiff.io.RandomInput;
import org.badiff.io.StreamRandomInput;

public class RandomInputStream
extends InputStream
implements Random {
    protected RandomInput in;
    protected long mark = -1L;

    public RandomInputStream(File file) throws IOException {
        this(new FileRandomInput(file));
    }

    public RandomInputStream(byte[] buf) {
        this(new ByteBufferRandomInput(buf));
    }

    public RandomInputStream(ByteBuffer buf) {
        this(new ByteBufferRandomInput(buf));
    }

    public RandomInputStream(InputStream in, int bufSize) {
        this(new StreamRandomInput(in, bufSize));
    }

    public RandomInputStream(RandomInput in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.in.position();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException("unset mark");
        }
        this.in.seek(this.mark);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long first() {
        return this.in.first();
    }

    @Override
    public long last() {
        return this.in.last();
    }

    @Override
    public long position() {
        return this.in.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.in.seek(pos);
    }
}

