/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.badiff.io.RandomInput;

public class FileRandomInput
extends FilterInputStream
implements RandomInput {
    protected File file;
    protected long pos;
    protected DataInputStream data;

    public FileRandomInput(File file) throws IOException {
        super(new FileInputStream(file));
        this.file = file;
        this.data = new DataInputStream(this);
    }

    @Override
    public long first() {
        return 0L;
    }

    @Override
    public long last() {
        return this.file.length();
    }

    @Override
    public long position() {
        return this.pos;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.skip(pos - this.pos);
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b >= 0) {
            ++this.pos;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = super.read(b, off, len);
        if (r > 0) {
            this.pos += (long)r;
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > 0L) {
            long s = this.in.skip(n);
            this.pos += s;
            return s;
        }
        if (n < 0L) {
            this.in.close();
            this.in = new FileInputStream(this.file);
            this.in.skip(this.pos + n);
            this.pos += n;
            return n;
        }
        return 0L;
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.data.readFully(b);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.data.readFully(b, off, len);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.data.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.data.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.data.readUnsignedByte();
    }

    @Override
    public final short readShort() throws IOException {
        return this.data.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.data.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        return this.data.readChar();
    }

    @Override
    public final int readInt() throws IOException {
        return this.data.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this.data.readLong();
    }

    @Override
    public final float readFloat() throws IOException {
        return this.data.readFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        return this.data.readDouble();
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        return this.data.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.data.readUTF();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.data.skipBytes(n);
    }
}

