/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.io;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.badiff.io.RandomInput;

public class ByteBufferRandomInput
implements RandomInput {
    protected ByteBuffer buf;

    public ByteBufferRandomInput(ByteBuffer buf) {
        this.buf = buf;
    }

    public ByteBufferRandomInput(byte[] buf) {
        this(ByteBuffer.wrap(buf));
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.buf.get(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.buf.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        n = Math.min(n, this.buf.remaining());
        n = Math.max(n, -this.buf.position());
        this.buf.position(this.buf.position() + n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buf.get() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.buf.get();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return 0xFF & this.buf.get();
    }

    @Override
    public short readShort() throws IOException {
        return this.buf.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return 0xFFFF & this.buf.getShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.buf.getChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.buf.getInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.buf.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.buf.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.buf.getDouble();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long first() {
        return 0L;
    }

    @Override
    public long last() {
        return this.buf.limit();
    }

    @Override
    public long position() {
        return this.buf.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.buf.position((int)pos);
    }

    @Override
    public long skip(long count) throws IOException {
        return this.skipBytes((int)count);
    }

    @Override
    public int read() throws IOException {
        try {
            return 0xFF & this.buf.get();
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            if (this.buf.remaining() == 0) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            b[i] = this.buf.get();
        }
        return b.length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            if (this.buf.remaining() == 0) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            b[off + i] = this.buf.get();
        }
        return len;
    }

    @Override
    public int available() throws IOException {
        return this.buf.remaining();
    }

    @Override
    public void close() throws IOException {
    }
}

