/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.imp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.badiff.Diff;
import org.badiff.Op;
import org.badiff.io.Serialization;
import org.badiff.io.Serialized;
import org.badiff.q.ListOpQueue;
import org.badiff.q.OpQueue;

public class MemoryDiff
implements Diff,
Serialized {
    protected List<Op> ops = new ArrayList<Op>();

    public MemoryDiff() {
    }

    public MemoryDiff(Iterator<Op> ops) {
        this();
        this.store(ops);
    }

    @Override
    public void apply(InputStream orig, OutputStream target) throws IOException {
        for (Op e : this.ops) {
            e.apply(orig, target);
        }
    }

    @Override
    public void store(Iterator<Op> ops) {
        this.ops.clear();
        while (ops.hasNext()) {
            this.ops.add(ops.next());
        }
    }

    @Override
    public OpQueue queue() {
        return new MemoryOpQueue(this.ops);
    }

    public String toString() {
        return this.queue().consummerize();
    }

    @Override
    public void serialize(Serialization serial, OutputStream out) throws IOException {
        for (Op e : this.ops) {
            serial.writeObject(out, Op.class, e);
        }
        serial.writeObject(out, Op.class, new Op(0, 1, null));
    }

    @Override
    public void deserialize(Serialization serial, InputStream in) throws IOException {
        Op e = serial.readObject(in, Op.class);
        while (e.getOp() != 0) {
            this.ops.add(e);
            e = serial.readObject(in, Op.class);
        }
    }

    private class MemoryOpQueue
    extends ListOpQueue {
        private MemoryOpQueue(List<Op> ops) {
            super(ops);
        }

        @Override
        public boolean offer(Op e) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

