/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.imp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import org.badiff.Diff;
import org.badiff.Op;
import org.badiff.io.DefaultSerialization;
import org.badiff.io.RuntimeIOException;
import org.badiff.io.Serialization;
import org.badiff.io.Serialized;
import org.badiff.q.OpQueue;
import org.badiff.util.Streams;

public class FileDiff
extends File
implements Diff,
Serialized {
    private static final long serialVersionUID = 0L;
    protected Serialization serial = DefaultSerialization.newInstance();

    public FileDiff(File parent, String child) {
        super(parent, child);
    }

    public FileDiff(String parent, String child) {
        super(parent, child);
    }

    public FileDiff(String pathname) {
        super(pathname);
    }

    public FileDiff(URI uri) {
        super(uri);
    }

    public FileDiff(File file) {
        this(file.toURI());
    }

    public FileDiff(File parent, String child, Serialization serialization) {
        super(parent, child);
        this.serial = serialization;
    }

    public FileDiff(String parent, String child, Serialization serialization) {
        super(parent, child);
        this.serial = serialization;
    }

    public FileDiff(String pathname, Serialization serialization) {
        super(pathname);
        this.serial = serialization;
    }

    public FileDiff(URI uri, Serialization serialization) {
        super(uri);
        this.serial = serialization;
    }

    public FileDiff(File file, Serialization serialization) {
        this(file.toURI());
        this.serial = serialization;
    }

    @Override
    public void apply(InputStream orig, OutputStream target) throws IOException {
        OpQueue q = this.queue();
        Op e = q.poll();
        while (e != null) {
            e.apply(orig, target);
            e = q.poll();
        }
    }

    @Override
    public OpQueue queue() throws IOException {
        return new FileOpQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Iterator<Op> ops) throws IOException {
        FileOutputStream out = new FileOutputStream(this);
        try {
            while (ops.hasNext()) {
                this.serial.writeObject(out, Op.class, ops.next());
            }
            this.serial.writeObject(out, Op.class, new Op(0, 1, null));
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Serialization serial, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(this);
        try {
            Streams.copy(in, out);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserialize(Serialization serial, InputStream in) throws IOException {
        FileOutputStream out = new FileOutputStream(this);
        try {
            Op e = serial.readObject(in, Op.class);
            while (e.getOp() != 0) {
                this.serial.writeObject(out, Op.class, e);
                e = serial.readObject(in, Op.class);
            }
            this.serial.writeObject(out, Op.class, new Op(0, 1, null));
        }
        finally {
            out.close();
        }
    }

    private class FileOpQueue
    extends OpQueue {
        private InputStream self;
        private boolean closed;

        public FileOpQueue() throws IOException {
            this.self = new FileInputStream(FileDiff.this);
            this.closed = false;
        }

        @Override
        public boolean offer(Op e) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean pull() {
            if (!this.closed) {
                try {
                    Op e = FileDiff.this.serial.readObject(this.self, Op.class);
                    if (e.getOp() != 0) {
                        this.prepare(e);
                        return true;
                    }
                    this.close();
                }
                catch (IOException ioe) {
                    this.close();
                    throw new RuntimeIOException(ioe);
                }
            }
            return false;
        }

        private void close() {
            try {
                this.self.close();
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe);
            }
            finally {
                this.closed = true;
            }
        }

        public String toString() {
            return FileDiff.this.getName();
        }
    }
}

