/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.imp;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.DigestOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.badiff.Diff;
import org.badiff.Op;
import org.badiff.Queueable;
import org.badiff.imp.FileDiff;
import org.badiff.io.DataOutputOutputStream;
import org.badiff.io.DefaultSerialization;
import org.badiff.io.FileRandomInput;
import org.badiff.io.Random;
import org.badiff.io.RandomInput;
import org.badiff.io.RuntimeIOException;
import org.badiff.io.Serialization;
import org.badiff.io.Serialized;
import org.badiff.io.SmallNumberSerialization;
import org.badiff.p.Pipe;
import org.badiff.p.Pipeline;
import org.badiff.p.Pipes;
import org.badiff.q.OpQueue;
import org.badiff.q.RandomChunkingOpQueue;
import org.badiff.util.Digests;
import org.badiff.util.Streams;

public class BadiffFileDiff
extends File
implements Diff,
Serialized {
    private static final long serialVersionUID = 0L;
    public static String PIPELINE_CODE = "sGccruC";
    public static Pipe[] PIPES = Pipes.fromCodes(PIPELINE_CODE);
    public static Pipe PIPE = new Pipe(){

        @Override
        public Pipeline from(OpQueue q) {
            return new Pipeline(q, PIPES);
        }
    };
    public static final byte[] MAGIC = new byte[]{0, -34, -18, -17};
    public static final int VERSION = 1;
    public static final long FLAG_RANDOM_ACCESS = 1L;
    public static final long FLAG_DEFAULT_SERIALIZATION = 2L;
    public static final long FLAG_SMALL_NUMBER_SERIALIZATION = 4L;
    public static final long FLAG_UNSPECIFIED_SERIALIZATION = 8L;
    public static final long FLAG_OPTIONAL_DATA = 16L;
    protected Serialization serial = null;

    protected static void computeStats(Queueable diff, Header header) throws IOException {
        Header.Stats stats = header.stats;
        OpQueue q = diff.queue();
        long osize = 0L;
        long tsize = 0L;
        Op e = q.poll();
        while (e != null) {
            switch (e.getOp()) {
                case 1: {
                    stats.deleteCount++;
                    if (e.getRun() < 0) {
                        stats.rewindCount++;
                    }
                    osize += (long)e.getRun();
                    break;
                }
                case 2: {
                    stats.insertCount++;
                    tsize += (long)e.getRun();
                    break;
                }
                case 3: {
                    stats.nextCount++;
                    osize += (long)e.getRun();
                    tsize += (long)e.getRun();
                }
            }
            e = q.poll();
        }
        stats.inputSize = osize;
        stats.outputSize = tsize;
    }

    public BadiffFileDiff(String pathname) {
        super(pathname);
    }

    public BadiffFileDiff(URI uri) {
        super(uri);
    }

    public BadiffFileDiff(String parent, String child) {
        super(parent, child);
    }

    public BadiffFileDiff(File parent, String child) {
        super(parent, child);
    }

    public BadiffFileDiff(File file) {
        super(file.toURI());
    }

    public BadiffFileDiff(String pathname, Serialization serial) {
        super(pathname);
        this.serial = serial;
    }

    public BadiffFileDiff(URI uri, Serialization serial) {
        super(uri);
        this.serial = serial;
    }

    public BadiffFileDiff(String parent, String child, Serialization serial) {
        super(parent, child);
        this.serial = serial;
    }

    public BadiffFileDiff(File parent, String child, Serialization serial) {
        super(parent, child);
        this.serial = serial;
    }

    public BadiffFileDiff(File file, Serialization serial) {
        super(file.toURI());
        this.serial = serial;
    }

    public static void writeHeader(Header header, DataOutput out) throws IOException {
        long flags;
        if (header.flags != 0L) {
            flags = header.flags;
        } else {
            flags = 0L;
            if (header.stats.rewindCount > 0L) {
                flags |= 1L;
            }
            flags = header.serial instanceof DefaultSerialization ? (flags |= 2L) : (header.serial instanceof SmallNumberSerialization ? (flags |= 4L) : (flags |= 8L));
            if (header.optional != null) {
                flags |= 0x10L;
            }
        }
        out.write(MAGIC);
        out.writeInt(1);
        out.writeLong(flags);
        DataOutputOutputStream dout = new DataOutputOutputStream(out);
        header.stats.serialize(header.serial, dout);
        if (header.optional != null) {
            header.optional.serialize(header.serial, dout);
        }
    }

    public static Header readHeader(DataInputStream in, Serialization serial) throws IOException {
        Header header = new Header();
        byte[] magic = new byte[MAGIC.length];
        in.read(magic);
        if (!Arrays.equals(magic, MAGIC)) {
            throw new IOException("Invalid badiff magic");
        }
        int version = in.readInt();
        if (version < 1 || version > 1) {
            throw new IOException("Unrecognized version");
        }
        long flags = in.readLong();
        if ((flags & 2L) != 0L) {
            if (serial != null && !(serial instanceof DefaultSerialization)) {
                throw new IOException("Incompatible serialization; expected " + serial.getClass().getSimpleName() + ", file declares " + DefaultSerialization.class.getSimpleName());
            }
            if (serial == null) {
                serial = DefaultSerialization.newInstance();
            }
        }
        if ((flags & 4L) != 0L) {
            if (serial != null && !(serial instanceof SmallNumberSerialization)) {
                throw new IOException("Incompatible serialization; expected " + serial.getClass().getSimpleName() + ", file declares " + SmallNumberSerialization.class.getSimpleName());
            }
            if (serial == null) {
                serial = SmallNumberSerialization.newInstance();
            }
        }
        if ((flags & 8L) != 0L && serial == null) {
            throw new IOException("Incompatible serialization; expected file to specify, file declares unspecified");
        }
        Header.Stats stats = header.stats;
        stats.deserialize(serial, in);
        Header.Optional opt = null;
        if ((flags & 0x10L) != 0L) {
            opt = new Header.Optional();
            opt.deserialize(serial, in);
        }
        Header.access$1002(header, magic);
        header.version = version;
        header.flags = flags;
        header.serial = serial;
        header.stats = stats;
        header.optional = opt;
        return header;
    }

    public Header header() throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(this));
        Header header = BadiffFileDiff.readHeader(in, this.serial);
        in.close();
        return header;
    }

    public Header.Stats stats() throws IOException {
        return this.header().stats;
    }

    public void diff(File orig, File target) throws IOException {
        this.diff(orig, target, PIPELINE_CODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(File orig, File target, String pipeline) throws IOException {
        FileRandomInput oin = new FileRandomInput(orig);
        try {
            FileRandomInput tin = new FileRandomInput(target);
            try {
                this.diff(oin, tin, pipeline);
            }
            finally {
                tin.close();
            }
        }
        finally {
            oin.close();
        }
    }

    public void diff(RandomInput orig, RandomInput target, String pipeline) throws IOException {
        long opos = orig.position();
        long tpos = target.position();
        byte[] preHash = Digests.digest(orig, Digests.defaultDigest());
        byte[] postHash = Digests.digest(target, Digests.defaultDigest());
        orig.seek(opos);
        target.seek(tpos);
        FileDiff tmp = new FileDiff(this.getParentFile(), this.getName() + ".tmp");
        OpQueue q = new RandomChunkingOpQueue(orig, target);
        q = new Pipeline(q).into(pipeline).outlet();
        tmp.store(q);
        Header h = new Header();
        Header.Optional opt = h.optional = new Header.Optional();
        opt.setHashAlgorithm(Digests.defaultDigest().getAlgorithm());
        opt.setPreHash(preHash);
        opt.setPostHash(postHash);
        DataOutputStream self = new DataOutputStream(new FileOutputStream(this));
        BadiffFileDiff.store((DataOutput)self, this.serial, h, tmp.queue());
        self.close();
        tmp.delete();
    }

    public void apply(File orig, File target) throws IOException {
        byte[] actualPostHash;
        byte[] actualPreHash;
        Header header = this.header();
        Header.Optional opt = header.getOptional();
        byte[] expectedPreHash = null;
        byte[] expectedPostHash = null;
        if (opt != null) {
            if (opt.getHashAlgorithm() != null && opt.getPreHash() != null) {
                expectedPreHash = opt.getPreHash();
            }
            if (opt.getHashAlgorithm() != null && opt.getPostHash() != null) {
                expectedPostHash = opt.getPostHash();
            }
        }
        if (expectedPreHash != null && !Arrays.equals(expectedPreHash, actualPreHash = Digests.digest(orig, Digests.digest(opt.getHashAlgorithm())))) {
            throw new IOException("Hash mismatch on original, expected " + Digests.pretty(expectedPreHash) + ", actual " + Digests.pretty(actualPreHash));
        }
        File tmp = new File(target.getParentFile(), target.getName() + ".patching");
        OutputStream out = new FileOutputStream(tmp);
        DigestOutputStream digout = null;
        if (expectedPostHash != null) {
            digout = new DigestOutputStream(out, Digests.digest(opt.getHashAlgorithm()));
            out = digout;
        }
        FileRandomInput oin = new FileRandomInput(orig);
        this.apply(oin, out);
        out.close();
        if (digout != null && !Arrays.equals(expectedPostHash, actualPostHash = digout.getMessageDigest().digest())) {
            throw new IOException("Hash mismatch on target, expected " + Digests.pretty(expectedPostHash) + ", actual " + Digests.pretty(actualPostHash));
        }
        target.delete();
        tmp.renameTo(target);
    }

    @Override
    public void apply(InputStream orig, OutputStream target) throws IOException {
        Header header = this.header();
        if ((header.flags & 1L) != 0L && !(orig instanceof Random)) {
            throw new IOException(this + " requires a random-access original (" + Random.class + ")");
        }
        OpQueue q = this.queue();
        Op e = q.poll();
        while (e != null) {
            e.apply(orig, target);
            e = q.poll();
        }
    }

    @Override
    public void store(Iterator<Op> ops) throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this));
        BadiffFileDiff.store((DataOutput)out, this.serial, null, ops);
        out.close();
    }

    public static void store(DataOutput out, Serialization serial, Header header, Iterator<Op> ops) throws IOException {
        FileDiff tmp = new FileDiff(File.createTempFile("filediff", ".tmp"));
        tmp.store(ops);
        BadiffFileDiff.computeStats(tmp, header);
        if (serial == null) {
            serial = DefaultSerialization.newInstance();
        }
        header.serial = serial;
        BadiffFileDiff.writeHeader(header, out);
        DataOutputOutputStream dout = new DataOutputOutputStream(out);
        OpQueue q = tmp.queue();
        Op e = q.poll();
        while (e != null) {
            serial.writeObject(dout, Op.class, e);
            e = q.poll();
        }
        serial.writeObject(dout, Op.class, new Op(0, 1, null));
        tmp.delete();
    }

    public static void store(DataOutput out, Serialization serial, Header header, Queueable qq) throws IOException {
        BadiffFileDiff.computeStats(qq, header);
        if (serial == null) {
            serial = DefaultSerialization.newInstance();
        }
        header.serial = serial;
        BadiffFileDiff.writeHeader(header, out);
        DataOutputOutputStream dout = new DataOutputOutputStream(out);
        OpQueue q = qq.queue();
        Op e = q.poll();
        while (e != null) {
            serial.writeObject(dout, Op.class, e);
            e = q.poll();
        }
        serial.writeObject(dout, Op.class, new Op(0, 1, null));
    }

    @Override
    public OpQueue queue() throws IOException {
        return new FileBadiffOpQueue();
    }

    @Override
    public void serialize(Serialization serial, OutputStream out) throws IOException {
        serial.writeObject(out, Long.class, this.length());
        FileInputStream in = new FileInputStream(this);
        Streams.copy(in, out);
        in.close();
    }

    @Override
    public void deserialize(Serialization serial, InputStream in) throws IOException {
        long length = serial.readObject(in, Long.class);
        FileOutputStream out = new FileOutputStream(this);
        Streams.copy(in, out, length);
        out.close();
    }

    private class FileBadiffOpQueue
    extends OpQueue {
        private Header header;
        private DataInputStream self;
        private boolean closed;

        public FileBadiffOpQueue() throws IOException {
            this.self = new DataInputStream(new FileInputStream(BadiffFileDiff.this));
            this.header = BadiffFileDiff.readHeader(this.self, BadiffFileDiff.this.serial);
            this.closed = false;
        }

        @Override
        public boolean offer(Op e) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean pull() {
            if (!this.closed) {
                try {
                    Op e = this.header.serial.readObject(this.self, Op.class);
                    if (e.getOp() != 0) {
                        this.prepare(e);
                        return true;
                    }
                    this.close();
                }
                catch (IOException ioe) {
                    this.close();
                    throw new RuntimeIOException(ioe);
                }
            }
            return false;
        }

        private void close() {
            try {
                this.self.close();
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe);
            }
            finally {
                this.closed = true;
            }
        }

        public String toString() {
            return BadiffFileDiff.this.getName();
        }
    }

    public static class Header {
        private byte[] magic;
        private int version;
        private long flags;
        private Serialization serial;
        private Stats stats = new Stats();
        private Optional optional = null;

        public Header() {
        }

        public Header(long flags, Serialization serial) {
            this.flags = flags;
            this.serial = serial;
        }

        public byte[] getMagic() {
            return this.magic;
        }

        public int getVersion() {
            return this.version;
        }

        public long getFlags() {
            return this.flags;
        }

        public Serialization getSerial() {
            return this.serial;
        }

        public Stats getStats() {
            return this.stats;
        }

        public Optional getOptional() {
            return this.optional;
        }

        public void setOptional(Optional optional) {
            this.optional = optional;
        }

        static /* synthetic */ byte[] access$1002(Header x0, byte[] x1) {
            x0.magic = x1;
            return x1;
        }

        public static class Optional
        implements Serialized {
            private byte[] preHash;
            private byte[] postHash;
            private String hashAlgorithm;

            public byte[] getPreHash() {
                return this.preHash;
            }

            public void setPreHash(byte[] preHash) {
                this.preHash = preHash;
            }

            public byte[] getPostHash() {
                return this.postHash;
            }

            public void setPostHash(byte[] postHash) {
                this.postHash = postHash;
            }

            @Override
            public void serialize(Serialization serial, OutputStream out) throws IOException {
                serial.writeObject(out, String.class, this.hashAlgorithm);
                serial.writeObject(out, byte[].class, this.preHash);
                serial.writeObject(out, byte[].class, this.postHash);
            }

            @Override
            public void deserialize(Serialization serial, InputStream in) throws IOException {
                this.hashAlgorithm = serial.readObject(in, String.class);
                this.preHash = serial.readObject(in, byte[].class);
                this.postHash = serial.readObject(in, byte[].class);
            }

            public String getHashAlgorithm() {
                return this.hashAlgorithm;
            }

            public void setHashAlgorithm(String hashAlgorithm) {
                this.hashAlgorithm = hashAlgorithm;
            }
        }

        public static class Stats
        implements Serialized {
            private long rewindCount;
            private long nextCount;
            private long insertCount;
            private long deleteCount;
            private long inputSize;
            private long outputSize;

            @Override
            public void serialize(Serialization serial, OutputStream out) throws IOException {
                serial.writeObject(out, Long.class, this.rewindCount);
                serial.writeObject(out, Long.class, this.nextCount);
                serial.writeObject(out, Long.class, this.insertCount);
                serial.writeObject(out, Long.class, this.deleteCount);
                serial.writeObject(out, Long.class, this.inputSize);
                serial.writeObject(out, Long.class, this.outputSize);
            }

            @Override
            public void deserialize(Serialization serial, InputStream in) throws IOException {
                this.rewindCount = serial.readObject(in, Long.class);
                this.nextCount = serial.readObject(in, Long.class);
                this.insertCount = serial.readObject(in, Long.class);
                this.deleteCount = serial.readObject(in, Long.class);
                this.inputSize = serial.readObject(in, Long.class);
                this.outputSize = serial.readObject(in, Long.class);
            }

            public long getRewindCount() {
                return this.rewindCount;
            }

            public long getNextCount() {
                return this.nextCount;
            }

            public long getInsertCount() {
                return this.insertCount;
            }

            public long getDeleteCount() {
                return this.deleteCount;
            }

            public long getInputSize() {
                return this.inputSize;
            }

            public long getOutputSize() {
                return this.outputSize;
            }
        }
    }
}

