/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.fmt;

import java.io.DataOutput;
import java.io.IOException;
import org.badiff.Diff;
import org.badiff.Op;
import org.badiff.fmt.InputFormat;
import org.badiff.fmt.OutputFormat;
import org.badiff.io.RandomInput;
import org.badiff.io.RuntimeIOException;
import org.badiff.q.OpQueue;

public class GdiffFormat
implements OutputFormat,
InputFormat {
    @Override
    public void exportDiff(Diff diff, RandomInput orig, DataOutput out) throws IOException {
        out.writeByte(209);
        out.writeByte(255);
        out.writeByte(209);
        out.writeByte(255);
        out.writeByte(4);
        OpQueue q = diff.queue();
        long opos = 0L;
        Op e = q.poll();
        while (e != null) {
            switch (e.getOp()) {
                case 1: {
                    opos += (long)e.getRun();
                    break;
                }
                case 2: {
                    this.data(out, e.getData());
                    break;
                }
                case 3: {
                    this.copy(out, e.getRun(), opos);
                    opos += (long)e.getRun();
                }
            }
            e = q.poll();
        }
        this.eof(out);
    }

    private void eof(DataOutput out) throws IOException {
        out.writeByte(0);
    }

    private void data(DataOutput out, byte[] buf) throws IOException {
        if (buf.length <= 246) {
            out.writeByte(buf.length);
            out.write(buf);
            return;
        }
        if (buf.length < 65536) {
            out.writeByte(247);
            out.writeShort(buf.length);
            out.write(buf);
            return;
        }
        out.writeByte(248);
        out.writeInt(buf.length);
        out.write(buf);
    }

    private void copy(DataOutput out, int run, long pos) throws IOException {
        if (pos < 65536L) {
            if (run < 256) {
                out.writeByte(249);
                out.writeShort((int)pos);
                out.writeByte(run);
                return;
            }
            if (run < 65536) {
                out.writeByte(250);
                out.writeShort((int)pos);
                out.writeShort(run);
                return;
            }
            out.writeByte(251);
            out.writeShort((int)pos);
            out.writeInt(run);
            return;
        }
        if (pos <= Integer.MAX_VALUE) {
            if (run < 252) {
                out.writeByte(249);
                out.writeInt((int)pos);
                out.writeByte(run);
                return;
            }
            if (run < 65536) {
                out.writeByte(253);
                out.writeInt((int)pos);
                out.writeShort(run);
                return;
            }
            out.writeByte(254);
            out.writeInt((int)pos);
            out.writeInt(run);
            return;
        }
        out.writeByte(255);
        out.writeLong(pos);
        out.writeInt(run);
    }

    @Override
    public OpQueue importDiff(RandomInput orig, RandomInput ext) throws IOException {
        return new GdiffOpQueue(orig, ext);
    }

    private class GdiffOpQueue
    extends OpQueue {
        private RandomInput orig;
        private RandomInput ext;
        private boolean closed;

        public GdiffOpQueue(RandomInput orig, RandomInput ext) throws IOException {
            this.orig = orig;
            this.ext = ext;
            if (ext.readByte() != -47) {
                throw new IOException("invalid magic");
            }
            if (ext.readByte() != -1) {
                throw new IOException("invalid magic");
            }
            if (ext.readByte() != -47) {
                throw new IOException("invalid magic");
            }
            if (ext.readByte() != -1) {
                throw new IOException("invalid magic");
            }
            if (ext.readByte() != 4) {
                throw new IOException("invalid version");
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        protected boolean pull() {
            if (this.closed) {
                return false;
            }
            try {
                int b = 0xFF & this.ext.readByte();
                switch (b) {
                    case 0: {
                        this.closed = true;
                        break;
                    }
                    case 247: {
                        int len = this.ext.readShort() & 0xFFFF;
                        byte[] buf = new byte[len];
                        this.ext.readFully(buf);
                        this.prepare(new Op(2, len, buf));
                        break;
                    }
                    case 248: {
                        int len = this.ext.readInt();
                        byte[] buf = new byte[len];
                        this.ext.readFully(buf);
                        this.prepare(new Op(2, len, buf));
                        break;
                    }
                    case 249: {
                        long p = this.ext.readShort() & 0xFFFF;
                        int len = 0xFF & this.ext.readByte();
                        this.copy(p, len);
                        break;
                    }
                    case 250: {
                        long p = this.ext.readShort() & 0xFFFF;
                        int len = 0xFFFF & this.ext.readShort();
                        this.copy(p, len);
                        break;
                    }
                    case 251: {
                        long p = this.ext.readShort() & 0xFFFF;
                        int len = this.ext.readInt();
                        this.copy(p, len);
                        break;
                    }
                    case 252: {
                        long p = this.ext.readInt();
                        int len = 0xFF & this.ext.readByte();
                        this.copy(p, len);
                        break;
                    }
                    case 253: {
                        long p = this.ext.readInt();
                        int len = 0xFFFF & this.ext.readShort();
                        this.copy(p, len);
                        break;
                    }
                    case 254: {
                        long p = this.ext.readInt();
                        int len = this.ext.readInt();
                        this.copy(p, len);
                        break;
                    }
                    case 255: {
                        long p = this.ext.readLong();
                        int len = this.ext.readInt();
                        this.copy(p, len);
                        break;
                    }
                    default: {
                        int len = b;
                        byte[] buf = new byte[len];
                        this.ext.readFully(buf);
                        this.prepare(new Op(2, len, buf));
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copy(long p, int len) throws IOException {
            long pos = this.orig.position();
            if (p >= pos) {
                if (p > pos) {
                    this.prepare(new Op(1, (int)(p - pos), null));
                }
                this.prepare(new Op(3, len, null));
                this.orig.seek(p + (long)len);
                return;
            }
            byte[] buf = new byte[len];
            long oldpos = this.ext.position();
            try {
                this.ext.seek(p);
                this.ext.readFully(buf);
            }
            finally {
                this.ext.seek(oldpos);
            }
            this.prepare(new Op(2, len, buf));
        }
    }
}

