/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.fmt;

import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.util.Arrays;
import org.badiff.Diff;
import org.badiff.Op;
import org.badiff.fmt.InputFormat;
import org.badiff.fmt.OutputFormat;
import org.badiff.imp.BadiffFileDiff;
import org.badiff.io.DataInputInputStream;
import org.badiff.io.DefaultSerialization;
import org.badiff.io.NoopOutputStream;
import org.badiff.io.RandomInput;
import org.badiff.io.RandomInputStream;
import org.badiff.io.Serialization;
import org.badiff.q.OpQueue;
import org.badiff.util.Digests;
import org.badiff.util.Streams;

public class BadiffFormat
implements InputFormat,
OutputFormat {
    @Override
    public void exportDiff(Diff diff, RandomInput orig, DataOutput out) throws IOException {
        BadiffFileDiff.Header hdr = new BadiffFileDiff.Header();
        BadiffFileDiff.Header.Optional opt = hdr.getOptional();
        long opos = orig.position();
        opt.setHashAlgorithm(Digests.defaultDigest().getAlgorithm());
        DigestInputStream digin = new DigestInputStream(new RandomInputStream(orig), Digests.defaultDigest());
        DigestOutputStream digout = new DigestOutputStream(new NoopOutputStream(), Digests.defaultDigest());
        diff.apply(digin, digout);
        orig.seek(opos);
        opt.setPreHash(digin.getMessageDigest().digest());
        opt.setPostHash(digout.getMessageDigest().digest());
        BadiffFileDiff.store(out, (Serialization)DefaultSerialization.newInstance(), hdr, diff.queue());
    }

    @Override
    public OpQueue importDiff(RandomInput orig, RandomInput ext) throws IOException {
        DataInputInputStream din = new DataInputInputStream(ext);
        BadiffFileDiff bd = new BadiffFileDiff(File.createTempFile("badiff", ".tmp"));
        bd.deleteOnExit();
        FileOutputStream bdo = new FileOutputStream(bd);
        Streams.copy(din, bdo);
        bdo.close();
        BadiffFileDiff.Header.Optional opt = bd.header().getOptional();
        if (opt != null && opt.getHashAlgorithm() != null && opt.getPreHash() != null) {
            long opos = orig.position();
            DigestInputStream digin = new DigestInputStream(new DataInputInputStream(orig), Digests.digest(opt.getHashAlgorithm()));
            Streams.copy(digin, new NoopOutputStream());
            orig.seek(opos);
            byte[] actualPreHash = digin.getMessageDigest().digest();
            if (!Arrays.equals(opt.getPreHash(), actualPreHash)) {
                throw new IOException("Pre-hash mismatch, expected " + Arrays.toString(opt.getPreHash()) + ", found " + Arrays.toString(actualPreHash));
            }
        }
        return new BadiffFormatOpQueue(bd);
    }

    private class BadiffFormatOpQueue
    extends OpQueue {
        private BadiffFileDiff bd;
        private OpQueue q;

        private BadiffFormatOpQueue(BadiffFileDiff bd) throws IOException {
            this.bd = bd;
            this.q = bd.queue();
        }

        @Override
        protected boolean pull() {
            Op e = this.q.poll();
            if (e != null) {
                this.prepare(e);
            } else {
                this.bd.delete();
            }
            return e != null;
        }

        public String toString() {
            return this.bd.getName();
        }
    }
}

