/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.alg;

import java.util.ArrayList;
import org.badiff.Op;
import org.badiff.alg.Graph;
import org.badiff.q.CompactingOpQueue;
import org.badiff.q.ListOpQueue;
import org.badiff.q.OpQueue;
import org.badiff.util.Integers;

public class InertialGraph
implements Graph {
    private static final int[][] DEFAULT_TRANSITION_COSTS = new int[][]{{1, 1, 1, 1}, {3, 1, 3, 4}, {2, 2, 1, 3}, {1, 2, 3, 1}};
    protected static final int DELETE = 0;
    protected static final int INSERT = 1;
    protected static final int NEXT = 2;
    protected static final int NUM_FIELDS = 3;
    protected final short[] cost;
    protected final int capacity;
    protected byte[] xval;
    protected byte[] yval;

    protected int cost(byte from, byte to) {
        return DEFAULT_TRANSITION_COSTS[from][to];
    }

    public InertialGraph() {
        this(0x401001);
    }

    public InertialGraph(int capacity) {
        if (capacity < 4) {
            throw new IllegalArgumentException("capacity must be >= 4");
        }
        this.capacity = capacity;
        this.cost = new short[3 * capacity];
    }

    @Override
    public void compute(byte[] orig, byte[] target) {
        if ((orig.length + 1) * (target.length + 1) > this.capacity) {
            throw new IllegalArgumentException("diff axes exceed graph capacity");
        }
        this.xval = new byte[orig.length + 1];
        System.arraycopy(orig, 0, this.xval, 1, orig.length);
        this.yval = new byte[target.length + 1];
        System.arraycopy(target, 0, this.yval, 1, target.length);
        this.cost[0] = 0;
        this.cost[1] = 0;
        this.cost[2] = 0;
        int cdd = this.cost((byte)1, (byte)1);
        int cdi = this.cost((byte)1, (byte)2);
        int cdn = this.cost((byte)1, (byte)3);
        int cid = this.cost((byte)2, (byte)1);
        int cii = this.cost((byte)2, (byte)2);
        int cin = this.cost((byte)2, (byte)3);
        int cnd = this.cost((byte)3, (byte)1);
        int cni = this.cost((byte)3, (byte)2);
        int cnn = this.cost((byte)3, (byte)3);
        int costLength = this.cost.length;
        int xvalLength = this.xval.length;
        int yvalLength = this.yval.length;
        int pmax = xvalLength * yvalLength;
        int x = 0;
        int y = 0;
        for (int pos = 0; pos < pmax; ++pos) {
            int f = (pos - 1) * 3 + 0;
            f = (f + costLength) % costLength;
            int edc = Integers.cmp((long)x, 0L, Integers.cmp((long)y, 0L, 0, Short.MAX_VALUE), (int)this.cost[f]);
            f = (pos - xvalLength) * 3 + 1;
            f = (f + costLength) % costLength;
            int eic = Integers.cmp((long)y, 0L, Integers.cmp((long)x, 0L, 0, Short.MAX_VALUE), (int)this.cost[f]);
            f = (pos - 1 - xvalLength) * 3 + 2;
            f = (f + costLength) % costLength;
            int enc = Integers.cmp((long)x, 0L, Integers.cmp((long)y, 0L, 0, Short.MAX_VALUE), (int)Integers.cmp((long)y, 0L, (short)Short.MAX_VALUE, Integers.cmp((long)this.xval[x], (long)this.yval[y], this.cost[f], (short)Short.MAX_VALUE)));
            int cost = edc + cdd;
            cost = Integers.min(cost, eic + cid);
            cost = Integers.min(cost, enc + cnd);
            this.cost[pos * 3 + 0] = (short)Integers.min(cost, Short.MAX_VALUE);
            cost = eic + cii;
            cost = Integers.min(cost, edc + cdi);
            cost = Integers.min(cost, enc + cni);
            this.cost[pos * 3 + 1] = (short)Integers.min(cost, Short.MAX_VALUE);
            cost = enc + cnn;
            cost = Integers.min(cost, edc + cdn);
            cost = Integers.min(cost, eic + cin);
            this.cost[pos * 3 + 2] = (short)Integers.min(cost, Short.MAX_VALUE);
            y += ++x / xvalLength;
            x %= xvalLength;
        }
    }

    @Override
    public OpQueue queue() {
        GraphOpQueue rq = new GraphOpQueue();
        ArrayList<Op> ops = new ArrayList<Op>();
        Op e = rq.poll();
        while (e != null) {
            ops.add(0, e);
            e = rq.poll();
        }
        OpQueue q = new ListOpQueue(ops);
        q = new CompactingOpQueue(q);
        return q;
    }

    protected class GraphOpQueue
    extends OpQueue {
        protected int pos;
        protected byte prev = 0;
        protected int x;
        protected int y;

        public GraphOpQueue() {
            this.pos = InertialGraph.this.xval.length * InertialGraph.this.yval.length - 1;
            this.x = InertialGraph.this.xval.length - 1;
            this.y = InertialGraph.this.yval.length - 1;
        }

        @Override
        protected boolean pull() {
            if (this.pos == 0) {
                return false;
            }
            int op = -1;
            int cost = Integer.MAX_VALUE;
            if (this.x > 0 && this.y > 0 && InertialGraph.this.xval[this.x] == InertialGraph.this.yval[this.y]) {
                op = 3;
                cost = InertialGraph.this.cost[(this.pos - 1 - InertialGraph.this.xval.length) * 3 + 2] + InertialGraph.this.cost((byte)3, this.prev);
            }
            if (this.y > 0 && InertialGraph.this.cost[(this.pos - InertialGraph.this.xval.length) * 3 + 1] + InertialGraph.this.cost((byte)2, this.prev) < cost) {
                op = 2;
                cost = InertialGraph.this.cost[(this.pos - InertialGraph.this.xval.length) * 3 + 1] + InertialGraph.this.cost((byte)2, this.prev);
            }
            if (this.x > 0 && InertialGraph.this.cost[(this.pos - 1) * 3 + 0] + InertialGraph.this.cost((byte)1, this.prev) < cost) {
                op = 1;
                cost = InertialGraph.this.cost[(this.pos - 1) * 3 + 0] + InertialGraph.this.cost((byte)1, this.prev);
            }
            Op e = null;
            switch (op) {
                case 3: {
                    e = new Op(3, 1, null);
                    this.pos = this.pos - 1 - InertialGraph.this.xval.length;
                    --this.x;
                    --this.y;
                    break;
                }
                case 2: {
                    e = new Op(2, 1, new byte[]{InertialGraph.this.yval[this.y]});
                    this.pos -= InertialGraph.this.xval.length;
                    --this.y;
                    break;
                }
                case 1: {
                    e = new Op(1, 1, new byte[]{InertialGraph.this.xval[this.x]});
                    --this.pos;
                    --this.x;
                }
            }
            if (e == null) {
                throw new IllegalStateException();
            }
            this.prepare(e);
            this.prev = e.getOp();
            return true;
        }
    }
}

