/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.alg;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.badiff.Op;
import org.badiff.alg.Graph;
import org.badiff.q.ListOpQueue;
import org.badiff.q.OpQueue;

public class EditGraph
implements Graph {
    protected byte[] flags;
    protected short[] lengths;
    protected byte[] xval;
    protected byte[] yval;

    public EditGraph(int size) {
        this.flags = new byte[size];
        this.lengths = new short[size];
        this.lengths[0] = Short.MIN_VALUE;
    }

    @Override
    public void compute(byte[] orig, byte[] target) {
        this.xval = new byte[orig.length + 1];
        this.yval = new byte[target.length + 1];
        System.arraycopy(orig, 0, this.xval, 1, orig.length);
        System.arraycopy(target, 0, this.yval, 1, target.length);
        for (int y = 0; y < this.yval.length; ++y) {
            for (int x = 0; x < this.xval.length; ++x) {
                int ilen;
                if (x == 0 && y == 0) continue;
                int pos = x + y * this.xval.length;
                if (x > 0 && y > 0 && this.xval[x] == this.yval[y]) {
                    this.flags[pos] = 3;
                    this.lengths[pos] = (short)(1 + this.lengths[pos - this.xval.length - 1]);
                    continue;
                }
                int dlen = x > 0 ? (int)(1 + this.lengths[pos - 1]) : Short.MAX_VALUE;
                int n = ilen = y > 0 ? (int)(1 + this.lengths[pos - this.xval.length]) : Short.MAX_VALUE;
                if (dlen <= ilen) {
                    this.flags[pos] = 1;
                    this.lengths[pos] = dlen;
                    continue;
                }
                this.flags[pos] = 2;
                this.lengths[pos] = ilen;
            }
        }
    }

    @Override
    public OpQueue queue() {
        List<Op> ops = this.rlist();
        Collections.reverse(ops);
        return new ListOpQueue(ops);
    }

    public List<Op> rlist() {
        ArrayList<Op> ret = new ArrayList<Op>();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte op = 0;
        int run = 0;
        int pos = this.xval.length * this.yval.length - 1;
        while (pos > 0) {
            byte fop = this.flags[pos];
            if (op != 0 && op != fop) {
                byte[] data = null;
                if (op == 2 || op == 1) {
                    byte[] rdata = buf.toByteArray();
                    data = new byte[rdata.length];
                    for (int i = 0; i < rdata.length; ++i) {
                        data[data.length - i - 1] = rdata[i];
                    }
                }
                ret.add(new Op(op, run, data));
                run = 0;
                buf.reset();
            }
            op = fop;
            ++run;
            if (op == 2) {
                buf.write(this.yval[pos / this.xval.length]);
                pos -= this.xval.length;
            }
            if (op == 1) {
                buf.write(this.xval[pos % this.xval.length]);
                --pos;
            }
            if (op != 3) continue;
            pos -= this.xval.length + 1;
        }
        if (op != 0) {
            byte[] data = null;
            if (op == 2 || op == 1) {
                byte[] rdata = buf.toByteArray();
                data = new byte[rdata.length];
                for (int i = 0; i < rdata.length; ++i) {
                    data[data.length - i - 1] = rdata[i];
                }
            }
            ret.add(new Op(op, run, data));
        }
        return ret;
    }
}

