/*
 * Decompiled with CFR 0.152.
 */
package org.badiff;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.badiff.Applyable;
import org.badiff.io.Serialization;
import org.badiff.io.Serialized;
import org.badiff.util.Streams;

public class Op
implements Applyable,
Serialized {
    public static final int VERSION = 1;
    public static final byte STOP = 0;
    public static final byte DELETE = 1;
    public static final byte INSERT = 2;
    public static final byte NEXT = 3;
    private byte op;
    private int run;
    private byte[] data;

    public Op() {
    }

    public Op(byte op, int run, byte[] data) {
        if ((op & 3) != op) {
            throw new IllegalArgumentException("invalid op");
        }
        if (run < 1 && op != 1 || data != null && run > data.length) {
            throw new IllegalArgumentException("invalid run");
        }
        if (op == 2 && data == null) {
            throw new IllegalArgumentException("invalid data");
        }
        this.op = op;
        this.run = run;
        this.data = data;
    }

    public String toString() {
        switch (this.op) {
            case 0: {
                return ";";
            }
            case 1: {
                return "-" + this.run;
            }
            case 2: {
                return "+" + this.run;
            }
            case 3: {
                return ">" + this.run;
            }
        }
        return "?";
    }

    @Override
    public void apply(InputStream orig, OutputStream target) throws IOException {
        switch (this.op) {
            case 1: {
                orig.skip(this.run);
                break;
            }
            case 3: {
                Streams.copy(orig, target, this.run);
                break;
            }
            case 2: {
                target.write(this.data, 0, this.run);
            }
        }
    }

    public byte getOp() {
        return this.op;
    }

    public int getRun() {
        return this.run;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void serialize(Serialization serial, OutputStream out) throws IOException {
        long oprun = (long)(this.op | (this.data != null ? 4 : 0)) | (long)this.run << 3;
        serial.writeObject(out, Long.class, oprun);
        if ((this.op == 2 || this.op == 1) && this.data != null) {
            serial.writeObject(out, byte[].class, this.data);
        }
    }

    @Override
    public void deserialize(Serialization serial, InputStream in) throws IOException {
        long oprun = serial.readObject(in, Long.class);
        this.op = (byte)(oprun & 3L);
        boolean hasData = (oprun & 4L) != 0L;
        this.run = (int)(oprun >>> 3);
        if ((this.op == 2 || this.op == 1) && hasData) {
            this.data = serial.readObject(in, byte[].class);
        }
    }
}

