/*
 * Decompiled with CFR 0.152.
 */
package org.badiff;

import org.badiff.imp.MemoryDiff;
import org.badiff.io.DefaultSerialization;
import org.badiff.q.OneWayOpQueue;
import org.badiff.q.UndoOpQueue;
import org.badiff.util.Diffs;
import org.badiff.util.Serials;

public class ByteArrayDiffs {
    public static byte[] diff(byte[] orig, byte[] target) {
        MemoryDiff md = new MemoryDiff();
        md.store(Diffs.improved(Diffs.queue(orig, target)));
        return Serials.serialize(DefaultSerialization.newInstance(), MemoryDiff.class, md);
    }

    public static byte[] apply(byte[] orig, byte[] diff) {
        MemoryDiff md = Serials.deserialize(DefaultSerialization.newInstance(), MemoryDiff.class, diff);
        return Diffs.apply(md, orig);
    }

    public static byte[] udiff(byte[] orig, byte[] target) {
        MemoryDiff md = new MemoryDiff();
        md.store(new OneWayOpQueue(Diffs.improved(Diffs.queue(orig, target))));
        return Serials.serialize(DefaultSerialization.newInstance(), MemoryDiff.class, md);
    }

    public static byte[] undo(byte[] target, byte[] diff) {
        MemoryDiff md = Serials.deserialize(DefaultSerialization.newInstance(), MemoryDiff.class, diff);
        return Diffs.apply(new UndoOpQueue(md.queue()), target);
    }

    public static byte[] udiff(byte[] diff) {
        MemoryDiff md = Serials.deserialize(DefaultSerialization.newInstance(), MemoryDiff.class, diff);
        md.store(new OneWayOpQueue(md.queue()));
        return Serials.serialize(DefaultSerialization.newInstance(), MemoryDiff.class, md);
    }

    public static byte[] undo(byte[] diff) {
        MemoryDiff md = Serials.deserialize(DefaultSerialization.newInstance(), MemoryDiff.class, diff);
        md.store(new UndoOpQueue(md.queue()));
        return Serials.serialize(DefaultSerialization.newInstance(), MemoryDiff.class, md);
    }

    private ByteArrayDiffs() {
    }
}

