/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.fluid;

import cn.mcmod_mmf.mmlib.fluid.FluidHelper;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.IReverseTag;

public abstract class FluidIngredient
implements Predicate<FluidStack> {
    public static final FluidIngredient EMPTY = NullFluidIngredient.EMPTY;
    public List<FluidStack> matchingFluidStacks;
    protected int amountRequired;

    public static FluidIngredient fromTag(TagKey<Fluid> tag, int amount) {
        FluidTagIngredient ingredient = new FluidTagIngredient();
        ingredient.tag = tag;
        ingredient.amountRequired = amount;
        return ingredient;
    }

    public static FluidIngredient fromFluid(Fluid fluid, int amount) {
        FluidStackIngredient ingredient = new FluidStackIngredient();
        ingredient.fluid = fluid;
        ingredient.amountRequired = amount;
        ingredient.fixFlowing();
        return ingredient;
    }

    public static FluidIngredient fromFluidStack(FluidStack fluidStack) {
        FluidStackIngredient ingredient = new FluidStackIngredient();
        ingredient.fluid = fluidStack.getFluid();
        ingredient.amountRequired = fluidStack.getAmount();
        ingredient.fixFlowing();
        if (fluidStack.hasTag()) {
            ingredient.tagToMatch = fluidStack.getTag();
        }
        return ingredient;
    }

    protected abstract boolean testInternal(FluidStack var1);

    protected abstract void readInternal(JsonObject var1);

    protected abstract void writeInternal(JsonObject var1);

    protected abstract List<FluidStack> determineMatchingFluidStacks();

    public int getRequiredAmount() {
        return this.amountRequired;
    }

    public List<FluidStack> getMatchingFluidStacks() {
        if (this.matchingFluidStacks != null) {
            return this.matchingFluidStacks;
        }
        this.matchingFluidStacks = this.determineMatchingFluidStacks();
        return this.matchingFluidStacks;
    }

    @Override
    public boolean test(FluidStack t) {
        if (t == null) {
            throw new IllegalArgumentException("FluidStack cannot be null");
        }
        return this.testInternal(t);
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        this.writeInternal(json);
        if (this.amountRequired != 0) {
            json.addProperty("amount", (Number)this.amountRequired);
        }
        return json;
    }

    public static boolean isFluidIngredient(@Nullable JsonElement je) {
        if (je == null || je.isJsonNull()) {
            return false;
        }
        if (!je.isJsonObject()) {
            return false;
        }
        JsonObject json = je.getAsJsonObject();
        if (json.has("null_fluid")) {
            return true;
        }
        if (json.has("fluidTag")) {
            return true;
        }
        return json.has("fluid");
    }

    public static FluidIngredient deserialize(@Nullable JsonElement je) {
        if (!FluidIngredient.isFluidIngredient(je)) {
            throw new JsonSyntaxException("Invalid fluid ingredient: " + Objects.toString(je));
        }
        JsonObject json = je.getAsJsonObject();
        if (json.has("null_fluid")) {
            if (!json.get("null_fluid").getAsBoolean()) {
                throw new JsonSyntaxException("'null_fluid' can NOT be false, delete it: " + Objects.toString(je));
            }
            return EMPTY;
        }
        FluidIngredient ingredient = json.has("fluidTag") ? new FluidTagIngredient() : new FluidStackIngredient();
        ingredient.readInternal(json);
        if (!json.has("amount")) {
            throw new JsonSyntaxException("Fluid ingredient has to define an amount");
        }
        ingredient.amountRequired = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
        return ingredient;
    }

    public static class FluidTagIngredient
    extends FluidIngredient {
        protected TagKey<Fluid> tag;

        @Override
        protected boolean testInternal(FluidStack t) {
            if (this.tag == null) {
                for (FluidStack accepted : this.getMatchingFluidStacks()) {
                    if (!accepted.getFluid().m_6212_(t.getFluid())) continue;
                    return true;
                }
            }
            return ((IReverseTag)ForgeRegistries.FLUIDS.tags().getReverseTag((Object)t.getFluid()).get()).containsTag(this.tag);
        }

        @Override
        protected void readInternal(JsonObject json) {
            ResourceLocation name = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluidTag"));
            this.tag = FluidTags.create((ResourceLocation)name);
        }

        @Override
        protected void writeInternal(JsonObject json) {
            json.addProperty("fluidTag", this.tag.f_203868_().toString());
        }

        @Override
        protected List<FluidStack> determineMatchingFluidStacks() {
            return ForgeRegistries.FLUIDS.tags().getTag(this.tag).stream().map(f -> {
                if (f instanceof FlowingFluid) {
                    return ((FlowingFluid)f).m_5613_();
                }
                return f;
            }).distinct().map(f -> new FluidStack(f, this.amountRequired)).collect(Collectors.toList());
        }
    }

    public static class FluidStackIngredient
    extends FluidIngredient {
        protected Fluid fluid;
        protected CompoundTag tagToMatch = new CompoundTag();

        void fixFlowing() {
            if (this.fluid instanceof FlowingFluid) {
                this.fluid = ((FlowingFluid)this.fluid).m_5613_();
            }
        }

        @Override
        protected boolean testInternal(FluidStack t) {
            if (!t.getFluid().m_6212_(this.fluid)) {
                return false;
            }
            if (this.tagToMatch.m_128456_()) {
                return true;
            }
            CompoundTag tag = t.getOrCreateTag();
            return tag.m_6426_().m_128391_(this.tagToMatch).equals((Object)tag);
        }

        @Override
        protected void readInternal(JsonObject json) {
            FluidStack stack = FluidHelper.deserializeFluidStack(json);
            this.fluid = stack.getFluid();
            this.tagToMatch = stack.getOrCreateTag();
        }

        @Override
        protected void writeInternal(JsonObject json) {
            json.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid).toString());
            json.add("nbt", JsonParser.parseString((String)this.tagToMatch.toString()));
        }

        @Override
        protected List<FluidStack> determineMatchingFluidStacks() {
            return ImmutableList.of((Object)(this.tagToMatch.m_128456_() ? new FluidStack(this.fluid, this.amountRequired) : new FluidStack(this.fluid, this.amountRequired, this.tagToMatch)));
        }
    }

    private static class NullFluidIngredient
    extends FluidIngredient {
        private static final NullFluidIngredient EMPTY = new NullFluidIngredient();

        private NullFluidIngredient() {
        }

        @Override
        protected boolean testInternal(FluidStack t) {
            return true;
        }

        @Override
        protected void readInternal(JsonObject json) {
        }

        @Override
        protected void writeInternal(JsonObject json) {
            json.addProperty("null_fluid", Boolean.valueOf(true));
        }

        @Override
        protected List<FluidStack> determineMatchingFluidStacks() {
            return ImmutableList.of((Object)new FluidStack(Fluids.f_76191_, 0));
        }
    }
}

