/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered.powersink;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.capabilities.Capabilities;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

class PoweredItemCapabilities
implements ICapabilityProvider,
IEnergyStorage {
    private final ItemStack is;
    private final IAEItemPowerStorage item;

    PoweredItemCapabilities(ItemStack is, IAEItemPowerStorage item) {
        this.is = is;
        this.item = item;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == Capabilities.FORGE_ENERGY) {
            return LazyOptional.of(() -> this);
        }
        return LazyOptional.empty();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        double convertedOffer = PowerUnits.FE.convertTo(PowerUnits.AE, maxReceive);
        double overflow = this.item.injectAEPower(this.is, convertedOffer, simulate ? Actionable.SIMULATE : Actionable.MODULATE);
        return maxReceive - (int)PowerUnits.AE.convertTo(PowerUnits.FE, overflow);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return (int)PowerUnits.AE.convertTo(PowerUnits.FE, this.item.getAECurrentPower(this.is));
    }

    public int getMaxEnergyStored() {
        return (int)PowerUnits.AE.convertTo(PowerUnits.FE, this.item.getAEMaxPower(this.is));
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

