/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.widgets;

import appeng.integration.modules.jei.widgets.AbstractWidget;
import appeng.integration.modules.jei.widgets.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class Label
extends AbstractWidget
implements Widget {
    public final float x;
    public final float y;
    public final Component text;
    private final Font font;
    public int color = -1;
    public int maxWidth = -1;
    public boolean shadow = true;
    private LabelAlignment align = LabelAlignment.CENTER;
    private List<FormattedLine> formattedLines = null;

    public Label(float x, float y, Component text) {
        this.x = x;
        this.y = y;
        this.text = text;
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public Rect2i getBounds() {
        int top = Integer.MAX_VALUE;
        int bottom = Integer.MIN_VALUE;
        int left = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        for (FormattedLine formattedLine : this.getLines()) {
            top = Math.min(top, (int)formattedLine.y);
            left = Math.min(left, (int)formattedLine.x);
            bottom = Math.max(bottom, (int)(formattedLine.y + (float)formattedLine.height));
            right = Math.max(right, (int)(formattedLine.x + (float)formattedLine.width));
        }
        return new Rect2i(left, top, right - left, bottom - top);
    }

    @Override
    public void draw(GuiGraphics guiGraphics) {
        for (FormattedLine line : this.getLines()) {
            Font font = Minecraft.m_91087_().f_91062_;
            guiGraphics.m_280649_(font, line.text, (int)line.x, (int)line.y, this.color, this.shadow);
        }
    }

    public Label bodyColor() {
        this.color = 0x7E7E7E;
        return this;
    }

    public Label alignLeft() {
        this.align = LabelAlignment.LEFT;
        return this;
    }

    public Label alignRight() {
        this.align = LabelAlignment.RIGHT;
        return this;
    }

    public Label tooltip(Component text) {
        this.setTooltipLines(List.of(text));
        return this;
    }

    public Label noShadow() {
        this.shadow = false;
        return this;
    }

    public Label bodyText() {
        this.noShadow();
        this.bodyColor();
        return this;
    }

    @Override
    public boolean hitTest(double x, double y) {
        for (FormattedLine line : this.getLines()) {
            if (!(x >= (double)line.x) || !(x < (double)(line.x + (float)line.width)) || !(y >= (double)line.y) || !(y < (double)(line.y + (float)line.height))) continue;
            return true;
        }
        return false;
    }

    private float getAlignedX(int width) {
        return switch (this.align) {
            default -> throw new IncompatibleClassChangeError();
            case LabelAlignment.LEFT -> this.x;
            case LabelAlignment.CENTER -> this.x - (float)width / 2.0f;
            case LabelAlignment.RIGHT -> this.x - (float)width;
        };
    }

    public Label maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    private List<FormattedLine> getLines() {
        if (this.formattedLines != null) {
            return this.formattedLines;
        }
        if (this.maxWidth == -1) {
            FormattedCharSequence formattedText = this.text.m_7532_();
            int width = this.font.m_92724_(formattedText);
            float f = this.getAlignedX(width);
            Objects.requireNonNull(this.font);
            this.formattedLines = List.of(new FormattedLine(formattedText, f, this.y, width, 9));
        } else {
            List splitLines = this.font.m_92923_((FormattedText)this.text, this.maxWidth);
            ArrayList<FormattedLine> formattedLines = new ArrayList<FormattedLine>(splitLines.size());
            for (int i = 0; i < splitLines.size(); ++i) {
                FormattedCharSequence splitLine = (FormattedCharSequence)splitLines.get(i);
                int width = this.font.m_92724_(splitLine);
                float f = this.getAlignedX(width);
                Objects.requireNonNull(this.font);
                float f2 = this.y + (float)(i * 9);
                Objects.requireNonNull(this.font);
                formattedLines.add(new FormattedLine(splitLine, f, f2, width, 9));
            }
            this.formattedLines = formattedLines;
        }
        return this.formattedLines;
    }

    private static enum LabelAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    private record FormattedLine(FormattedCharSequence text, float x, float y, int width, int height) {
    }
}

