/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class EraserItem
extends AEBaseItem {
    private static final int BOX_SIZE = 48;
    private static final int BLOCK_ERASE_LIMIT = 110592;
    static final Set<Block> COMMON_BLOCKS = new HashSet<Block>();

    public EraserItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43725_().m_5776_()) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Block state = level.m_8055_(pos).m_60734_();
        boolean bulk = InteractionUtil.isInAlternateUseMode(player);
        ArrayDeque<BlockPos> next = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        Set<Block> commonBlocks = this.getCommonBlocks();
        next.add(pos);
        int blocks = 0;
        while (blocks < 110592 && next.peek() != null) {
            BlockPos wc = (BlockPos)next.poll();
            Block c_state = level.m_8055_(wc).m_60734_();
            boolean contains = state == c_state || bulk && commonBlocks.contains(c_state);
            closed.add(wc);
            if (!contains) continue;
            ++blocks;
            level.m_7731_(wc, Blocks.f_50016_.m_49966_(), 2);
            level.m_46961_(wc, false);
            if (!this.isInsideBox(wc, pos)) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos nextPos;
                        if (0 == x && 0 == y && 0 == z || closed.contains(nextPos = wc.m_7918_(x, y, z))) continue;
                        next.add(nextPos);
                    }
                }
            }
        }
        AELog.info("Delete " + blocks + " blocks", new Object[0]);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private boolean isInsideBox(BlockPos pos, BlockPos origin) {
        boolean ret = true;
        if (pos.m_123341_() > origin.m_123341_() + 48 || pos.m_123341_() < origin.m_123341_() - 48) {
            ret = false;
        }
        if (pos.m_123342_() > origin.m_123342_() + 48 || pos.m_123342_() < origin.m_123342_() - 48) {
            ret = false;
        }
        if (pos.m_123343_() > origin.m_123343_() + 48 || pos.m_123343_() < origin.m_123343_() - 48) {
            ret = false;
        }
        return ret;
    }

    private Set<Block> getCommonBlocks() {
        if (COMMON_BLOCKS.isEmpty()) {
            COMMON_BLOCKS.add(Blocks.f_50069_);
            COMMON_BLOCKS.add(Blocks.f_50493_);
            COMMON_BLOCKS.add(Blocks.f_50440_);
            COMMON_BLOCKS.add(Blocks.f_50652_);
            COMMON_BLOCKS.add(Blocks.f_50334_);
            COMMON_BLOCKS.add(Blocks.f_50122_);
            COMMON_BLOCKS.add(Blocks.f_50228_);
            COMMON_BLOCKS.add(Blocks.f_49994_);
            COMMON_BLOCKS.add(Blocks.f_50062_);
            COMMON_BLOCKS.add(Blocks.f_50134_);
            COMMON_BLOCKS.add(Blocks.f_49990_);
            COMMON_BLOCKS.add(Blocks.f_49991_);
            COMMON_BLOCKS.addAll(BuiltInRegistries.f_256975_.m_203561_(BlockTags.f_13035_).m_203614_().map(Holder::m_203334_).toList());
            COMMON_BLOCKS.addAll(BuiltInRegistries.f_256975_.m_203561_(BlockTags.f_13029_).m_203614_().map(Holder::m_203334_).toList());
            COMMON_BLOCKS.addAll(BuiltInRegistries.f_256975_.m_203561_(BlockTags.f_13106_).m_203614_().map(Holder::m_203334_).toList());
        }
        return COMMON_BLOCKS;
    }

    @Override
    public void addToMainCreativeTab(CreativeModeTab.Output output) {
        if (AEConfig.instance().isDebugToolsEnabled()) {
            output.m_246326_((ItemLike)this);
        }
    }
}

