/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook;

import appeng.client.guidebook.LytInscriberRecipe;
import appeng.core.definitions.AEBlocks;
import appeng.core.localization.GuiText;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.transform.TransformRecipe;
import appeng.util.Platform;
import guideme.compiler.tags.RecipeTypeMappingSupplier;
import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytSlotGrid;
import guideme.document.block.recipes.LytStandardRecipeBox;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class RecipeTypeContributions
implements RecipeTypeMappingSupplier {
    public void collect(RecipeTypeMappingSupplier.RecipeTypeMappings mappings) {
        mappings.add(InscriberRecipe.TYPE, RecipeTypeContributions::inscribing);
        mappings.add(ChargerRecipe.TYPE, RecipeTypeContributions::charging);
        mappings.add(TransformRecipe.TYPE, RecipeTypeContributions::transform);
    }

    private static LytStandardRecipeBox<ChargerRecipe> charging(ChargerRecipe recipe) {
        return LytStandardRecipeBox.builder().icon(AEBlocks.CHARGER).title(((BlockItem)AEBlocks.CHARGER.m_5456_()).m_41466_().getString()).input(recipe.getIngredient()).outputFromResultOf((Recipe)recipe).build((Recipe)recipe);
    }

    private static LytStandardRecipeBox<InscriberRecipe> inscribing(InscriberRecipe recipe) {
        return LytStandardRecipeBox.builder().icon(AEBlocks.INSCRIBER).title(((BlockItem)AEBlocks.INSCRIBER.m_5456_()).m_41466_().getString()).customBody((LytBlock)new LytInscriberRecipe(recipe)).build((Recipe)recipe);
    }

    private static LytStandardRecipeBox<TransformRecipe> transform(TransformRecipe recipe) {
        LytStandardRecipeBox.Builder builder = LytStandardRecipeBox.builder().input(LytSlotGrid.column(recipe.m_7527_(), (boolean)true)).output(LytSlotGrid.column(List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{recipe.getResultItem()})), (boolean)true));
        if (recipe.circumstance.isExplosion()) {
            builder.icon((ItemLike)Blocks.f_50077_);
            builder.title(GuiText.TransformTypeExplode.text().getString());
        } else if (recipe.circumstance.isFluid()) {
            Fluid fluid = Fluids.f_76191_;
            if (recipe.circumstance.isFluidTag((TagKey<Fluid>)FluidTags.f_13131_)) {
                fluid = Fluids.f_76193_;
            } else {
                List<Fluid> fluidsForRendering = recipe.circumstance.getFluidsForRendering();
                if (!fluidsForRendering.isEmpty()) {
                    long cycle = System.currentTimeMillis() / 1500L;
                    fluid = fluidsForRendering.get((int)(cycle % (long)fluidsForRendering.size()));
                }
            }
            builder.icon((LytBlock)new FluidIcon(fluid));
            builder.title(GuiText.TransformTypeThrowInFluid.text(Platform.getFluidDisplayName(fluid)).getString());
        }
        return builder.build((Recipe)recipe);
    }

    static class FluidIcon
    extends LytBlock {
        private final Fluid fluid;

        public FluidIcon(Fluid fluid) {
            this.fluid = fluid;
        }

        protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
            return new LytRect(x, y, 8, 8);
        }

        protected void onLayoutMoved(int deltaX, int deltaY) {
        }

        public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        }

        public void render(RenderContext context) {
            context.renderFluid(this.fluid, this.bounds.x(), this.bounds.y(), 0, this.bounds.width(), this.bounds.height());
        }
    }
}

