/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.mixin;

import com.pyzpre.createbitterballen.block.sunflower.SunflowerStem;
import com.pyzpre.createbitterballen.index.BlockRegistry;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HarvesterMovementBehaviour.class}, remap=false)
public abstract class HarvesterMixin {
    @Inject(method={"visitNewPosition"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/contraptions/actors/harvester/HarvesterMovementBehaviour;isValidCrop(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z")}, cancellable=true)
    private void onVisitNewPosition(MovementContext context, BlockPos pos, CallbackInfo ci) {
        Level world = context.world;
        if (world.m_5776_()) {
            return;
        }
        BlockState stateVisited = world.m_8055_(pos);
        if (stateVisited.m_60713_(Blocks.f_50355_)) {
            this.handleHarvesterInteraction(world, pos, context, stateVisited);
            ci.cancel();
        }
    }

    private void handleHarvesterInteraction(Level world, BlockPos pos, MovementContext context, BlockState state) {
        ItemStack sunflowerHead = new ItemStack((ItemLike)Items.f_42206_);
        MountedItemStorageWrapper internalStorage = context.contraption.getStorage().getMountedItems();
        ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)internalStorage, (ItemStack)sunflowerHead, (boolean)false);
        if (!remaining.m_41619_()) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)remaining);
        }
        this.replaceWithSunflowerStem(world, pos, state);
        world.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void replaceWithSunflowerStem(Level world, BlockPos pos, BlockState state) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)DoublePlantBlock.f_52858_);
        BlockPos lowerPos = half == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        BlockPos upperPos = lowerPos.m_7494_();
        world.m_7731_(lowerPos, Blocks.f_50016_.m_49966_(), 18);
        world.m_7731_(upperPos, Blocks.f_50016_.m_49966_(), 18);
        BlockState lowerStemState = (BlockState)((BlockState)((SunflowerStem)((Object)BlockRegistry.SUNFLOWERSTEM.get())).m_49966_().m_61124_((Property)SunflowerStem.AGE, (Comparable)Integer.valueOf(2))).m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
        BlockState upperStemState = (BlockState)((BlockState)((SunflowerStem)((Object)BlockRegistry.SUNFLOWERSTEM.get())).m_49966_().m_61124_((Property)SunflowerStem.AGE, (Comparable)Integer.valueOf(2))).m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
        world.m_7731_(lowerPos, lowerStemState, 3);
        world.m_7731_(upperPos, upperStemState, 3);
    }
}

