/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.mechanicalfryer;

import com.pyzpre.createbitterballen.block.mechanicalfryer.DeepFryingRecipe;
import com.pyzpre.createbitterballen.block.mechanicalfryer.FryerOperatingBlockEntity;
import com.pyzpre.createbitterballen.index.RecipeRegistry;
import com.pyzpre.createbitterballen.index.SoundsRegistry;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class MechanicalFryerEntity
extends FryerOperatingBlockEntity {
    private static final Object DeepFryingRecipesKey = new Object();
    private boolean shouldRecalculateProcessingTicks = true;
    public SmartInventory inputInv = new SmartInventory(1, (SyncedBlockEntity)this);
    public SmartInventory outputInv = new SmartInventory(9, (SyncedBlockEntity)this);
    public LazyOptional<IItemHandler> capability = LazyOptional.of(() -> new FryerInventoryHandler(this.inputInv, this.outputInv));
    public int timer;
    private DeepFryingRecipe lastRecipe;
    public int runningTicks;
    public int processingTicks;
    public boolean running;

    public MechanicalFryerEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        super.addBehaviours(behaviours);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.running && this.speed != 0.0f) {
            if (this.runningTicks < 20) {
                int localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - Mth.m_14089_((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - Mth.m_14089_((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.running = compound.m_128471_("Running");
        this.runningTicks = compound.m_128451_("Ticks");
        this.timer = compound.m_128451_("Timer");
        this.inputInv.deserializeNBT(compound.m_128469_("InputInventory"));
        this.outputInv.deserializeNBT(compound.m_128469_("OutputInventory"));
        this.shouldRecalculateProcessingTicks = compound.m_128471_("ShouldRecalculate");
        super.read(compound, clientPacket);
        if (clientPacket && this.m_58898_()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128405_("Ticks", this.runningTicks);
        compound.m_128405_("Timer", this.timer);
        compound.m_128365_("InputInventory", (Tag)this.inputInv.serializeNBT());
        compound.m_128365_("OutputInventory", (Tag)this.outputInv.serializeNBT());
        compound.m_128379_("ShouldRecalculate", this.shouldRecalculateProcessingTicks);
        super.write(compound, clientPacket);
    }

    private boolean applyRecipe(DeepFryingRecipe recipe) {
        Optional<BasinBlockEntity> basinOpt = this.getBasin();
        if (basinOpt.isEmpty()) {
            return false;
        }
        BasinBlockEntity basin = basinOpt.get();
        IFluidHandler fluidHandler = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (fluidHandler == null) {
            return false;
        }
        int maxProcessableItems = this.inputInv.getStackInSlot(0).m_41613_();
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            int requiredAmount = fluidIngredient.getRequiredAmount();
            int totalMatchingAmount = 0;
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
                if (!fluidIngredient.test(fluidInTank)) continue;
                totalMatchingAmount += fluidInTank.getAmount();
            }
            maxProcessableItems = Math.min(maxProcessableItems, totalMatchingAmount / requiredAmount);
        }
        if (maxProcessableItems <= 0) {
            return false;
        }
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            int drainedAmount;
            FluidStack fluidInTank;
            int amountToConsume = fluidIngredient.getRequiredAmount() * maxProcessableItems;
            for (int tank = 0; !(tank >= fluidHandler.getTanks() || fluidIngredient.test(fluidInTank = fluidHandler.getFluidInTank(tank)) && (amountToConsume -= (drainedAmount = fluidHandler.drain(new FluidStack(fluidInTank, amountToConsume), IFluidHandler.FluidAction.EXECUTE).getAmount())) <= 0); ++tank) {
            }
        }
        ItemStack inputStack = this.inputInv.getStackInSlot(0);
        inputStack.m_41774_(maxProcessableItems);
        this.inputInv.setStackInSlot(0, inputStack);
        List outputs = recipe.rollResults();
        for (ItemStack output : outputs) {
            output.m_41764_(output.m_41613_() * maxProcessableItems);
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)output.m_41777_(), (boolean)false);
            if (remaining.m_41619_()) continue;
            return false;
        }
        basin.m_6596_();
        basin.sendData();
        this.sendData();
        this.m_6596_();
        return true;
    }

    public void tick() {
        if (this.basinRemoved) {
            this.basinRemoved = false;
            this.onBasinRemoved();
            this.sendData();
            return;
        }
        super.tick();
        float speed = Math.abs(this.getSpeed());
        boolean canStartProcessing = this.hasMatchingRecipe();
        float recipeSpeed = 1.0f;
        if (this.getSpeed() == 0.0f && this.running) {
            this.resetAnimationAndProcessing();
        }
        if (!this.running && canStartProcessing) {
            this.running = true;
            this.runningTicks = 0;
            this.shouldRecalculateProcessingTicks = true;
        }
        if (this.running) {
            if (this.processingTicks > 0) {
                if (this.runningTicks < 20) {
                    ++this.runningTicks;
                }
                --this.processingTicks;
            } else if (this.runningTicks < 40) {
                ++this.runningTicks;
            } else if (!canStartProcessing) {
                this.running = false;
                this.runningTicks = 0;
                this.shouldRecalculateProcessingTicks = false;
            } else {
                this.shouldRecalculateProcessingTicks = true;
                this.runningTicks = 0;
            }
            if (this.runningTicks == 20 && this.processingTicks == 1) {
                for (int slot = 0; slot < this.inputInv.getSlots(); ++slot) {
                    ItemStack stackInSlot = this.inputInv.getStackInSlot(slot);
                    if (!this.isIce(stackInSlot)) continue;
                    this.causeExplosion();
                    this.inputInv.setStackInSlot(slot, ItemStack.f_41583_);
                    break;
                }
            }
            if (this.runningTicks == 20) {
                if (this.processingTicks == 1) {
                    if (this.lastRecipe == null || !this.matchesRecipe(this.lastRecipe)) {
                        Optional<DeepFryingRecipe> recipeOpt = this.findMatchingRecipe(this.f_58857_);
                        this.lastRecipe = recipeOpt.orElse(null);
                        if (this.lastRecipe != null) {
                            // empty if block
                        }
                    }
                    if (this.lastRecipe == null || this.applyRecipe(this.lastRecipe)) {
                        // empty if block
                    }
                }
                if (this.runningTicks == 20 && this.shouldRecalculateProcessingTicks && canStartProcessing) {
                    int duration;
                    if (this.lastRecipe != null && (duration = this.lastRecipe.getProcessingDuration()) != 0) {
                        recipeSpeed = (float)duration / 100.0f;
                    }
                    this.processingTicks = Mth.m_14045_((int)(Mth.m_14173_((int)((int)(512.0f / speed))) * Mth.m_14167_((float)(recipeSpeed * 15.0f)) + 1), (int)1, (int)512);
                    this.shouldRecalculateProcessingTicks = false;
                }
            }
        }
    }

    private boolean isIce(ItemStack stack) {
        ResourceLocation iceTag = new ResourceLocation("forge", "ice");
        return stack.m_204117_(ItemTags.create((ResourceLocation)iceTag));
    }

    private void resetAnimationAndProcessing() {
        this.running = false;
        this.processingTicks = 0;
        this.runningTicks = 0;
    }

    private void grantAdvancementCriterion(ServerPlayer player) {
        AdvancementProgress advancementProgress;
        PlayerAdvancements playerAdvancements = player.m_8960_();
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("create_bic_bit:fry_about_it"));
        if (advancement != null && advancement.m_138325_().containsKey("ice_exploded") && !(advancementProgress = playerAdvancements.m_135996_(advancement)).m_8193_()) {
            playerAdvancements.m_135988_(advancement, "ice_exploded");
        }
    }

    private void causeExplosion() {
        if (!this.f_58857_.m_5776_()) {
            this.f_58857_.m_255391_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 4.0f, false, Level.ExplosionInteraction.MOB);
            double radius = 10.0;
            AABB area = new AABB(this.f_58858_).m_82400_(radius);
            List players = this.f_58857_.m_45976_(ServerPlayer.class, area);
            for (ServerPlayer player : players) {
                this.grantAdvancementCriterion(player);
            }
        }
    }

    private boolean hasMatchingRecipe() {
        if (this.inputInv.getStackInSlot(0).m_41619_()) {
            this.currentRecipe = null;
            return false;
        }
        Optional<DeepFryingRecipe> recipeOpt = this.findMatchingRecipe(this.f_58857_);
        if (recipeOpt.isEmpty()) {
            this.currentRecipe = null;
            return false;
        }
        DeepFryingRecipe recipe = recipeOpt.get();
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!this.isBlazeBurnerConfigured(requiredHeat)) {
            this.currentRecipe = null;
            return false;
        }
        this.currentRecipe = recipe;
        return true;
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInv);
    }

    private boolean isBlazeBurnerConfigured(HeatCondition requiredHeat) {
        if (requiredHeat == HeatCondition.NONE) {
            return true;
        }
        if (this.f_58857_ == null) {
            return false;
        }
        BlockPos posBelowBasin = this.f_58858_.m_6625_(3);
        BlockState blockStateBelow = this.f_58857_.m_8055_(posBelowBasin);
        BlazeBurnerBlock.HeatLevel actualHeat = BasinBlockEntity.getHeatLevelOf((BlockState)blockStateBelow);
        return requiredHeat.testBlazeBurner(actualHeat);
    }

    private Optional<DeepFryingRecipe> findMatchingRecipe(Level level) {
        for (Recipe recipe : level.m_7465_().m_44013_(RecipeRegistry.DEEP_FRYING.getType())) {
            DeepFryingRecipe deepFryingRecipe;
            if (!(recipe instanceof DeepFryingRecipe) || !this.matchesRecipe(deepFryingRecipe = (DeepFryingRecipe)recipe)) continue;
            return Optional.of(deepFryingRecipe);
        }
        return Optional.empty();
    }

    private boolean matchesRecipe(DeepFryingRecipe recipe) {
        ItemStack inputStack = this.inputInv.getStackInSlot(0);
        if (!((Ingredient)recipe.m_7527_().get(0)).test(inputStack)) {
            return false;
        }
        Optional<BasinBlockEntity> basinOpt = this.getBasin();
        if (basinOpt.isEmpty()) {
            return false;
        }
        BasinBlockEntity basin = basinOpt.get();
        IFluidHandler fluidHandler = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (fluidHandler == null) {
            return false;
        }
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            int requiredAmount = fluidIngredient.getRequiredAmount();
            int totalMatchingAmount = 0;
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
                if (fluidIngredient.test(fluidInTank)) {
                    totalMatchingAmount += fluidInTank.getAmount();
                }
                if (totalMatchingAmount >= requiredAmount) break;
            }
            if (totalMatchingAmount >= requiredAmount) continue;
            return false;
        }
        return true;
    }

    private boolean areBasinFluidsMatching(BasinBlockEntity basin, DeepFryingRecipe recipe) {
        IFluidHandler fluidHandler = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            FluidStack fluidInTank;
            int requiredAmount = fluidIngredient.getRequiredAmount();
            int totalMatchingAmount = 0;
            for (int tank = 0; !(tank >= fluidHandler.getTanks() || fluidIngredient.test(fluidInTank = fluidHandler.getFluidInTank(tank)) && MechanicalFryerEntity.hasMatchingNBT(fluidIngredient, fluidInTank) && (totalMatchingAmount += fluidInTank.getAmount()) >= requiredAmount); ++tank) {
            }
            if (totalMatchingAmount >= requiredAmount) continue;
            return false;
        }
        return true;
    }

    private static boolean hasMatchingNBT(FluidIngredient fluidIngredient, FluidStack fluidInTank) {
        for (FluidStack matchingFluid : fluidIngredient.getMatchingFluidStacks()) {
            boolean neitherHaveTag;
            boolean bothHaveTag = fluidInTank.hasTag() && matchingFluid.hasTag();
            boolean bl = neitherHaveTag = !fluidInTank.hasTag() && !matchingFluid.hasTag();
            if (!(bothHaveTag ? fluidInTank.getTag().equals((Object)matchingFluid.getTag()) : neitherHaveTag)) continue;
            return true;
        }
        return false;
    }

    public void renderParticles() {
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.isEmpty() || this.f_58857_ == null) {
            return;
        }
        for (SmartFluidTankBehaviour behaviour : basin.get().getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                this.spillParticle(FluidFX.getFluidParticle((FluidStack)tankSegment.getRenderedFluid()));
            }
        }
    }

    protected void spillParticle(ParticleOptions data) {
        float angle = this.f_58857_.f_46441_.m_188501_() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y).m_82520_(0.0, 0.25, 0.0);
        Vec3 center = offset.m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
        target = VecHelper.offsetRandomly((Vec3)target.m_82546_(offset), (RandomSource)this.f_58857_.f_46441_, (float)0.0078125f);
        this.f_58857_.m_7106_(data, center.f_82479_, center.f_82480_ - 1.75, center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
    }

    @Override
    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == RecipeRegistry.DEEP_FRYING.getType();
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    @Override
    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    @Override
    protected Object getRecipeCacheKey() {
        return DeepFryingRecipesKey;
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        boolean slow;
        super.tickAudio();
        boolean bl = slow = Math.abs(this.getSpeed()) < 65.0f;
        if (slow && AnimationTickHolder.getTicks() % 2 == 0) {
            return;
        }
        if (this.runningTicks == 20) {
            SoundsRegistry.FRYING.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.75f, 1.0f, true);
            this.renderParticles();
        }
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean canProcess(ItemStack stack) {
        if (this.lastRecipe != null && this.isItemValidForRecipe(this.lastRecipe, stack)) {
            return true;
        }
        List recipes = this.f_58857_.m_7465_().m_44013_(RecipeRegistry.DEEP_FRYING.get());
        for (DeepFryingRecipe recipe : recipes) {
            if (!this.isItemValidForRecipe(recipe, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isItemValidForRecipe(DeepFryingRecipe recipe, ItemStack stack) {
        return recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(stack));
    }

    private class FryerInventoryHandler
    extends CombinedInvWrapper {
        public FryerInventoryHandler(SmartInventory inputInv, SmartInventory outputInv) {
            super(new IItemHandlerModifiable[]{inputInv, outputInv});
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (MechanicalFryerEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return MechanicalFryerEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (MechanicalFryerEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (MechanicalFryerEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

