/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene;

import guideme.document.LytPoint;
import guideme.document.LytRect;
import guideme.scene.CameraSettings;
import guideme.scene.annotation.InWorldAnnotation;
import guideme.scene.annotation.OverlayAnnotation;
import guideme.scene.annotation.SceneAnnotation;
import guideme.scene.level.GuidebookLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalDouble;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectionf;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class GuidebookScene {
    private final GuidebookLevel level;
    private final CameraSettings cameraSettings;
    private final List<InWorldAnnotation> inWorldAnnotations = new ArrayList<InWorldAnnotation>();
    private final List<OverlayAnnotation> overlayAnnotations = new ArrayList<OverlayAnnotation>();
    private int width;
    private int height;

    public GuidebookScene(GuidebookLevel level, CameraSettings cameraSettings) {
        this.level = level;
        this.cameraSettings = cameraSettings;
    }

    public Vector4f getScreenBounds() {
        float offx = this.cameraSettings.getOffsetX();
        float offy = this.cameraSettings.getOffsetY();
        this.cameraSettings.setOffsetX(0.0f);
        this.cameraSettings.setOffsetY(0.0f);
        Matrix4f viewMatrix = this.cameraSettings.getViewMatrix();
        this.cameraSettings.setOffsetX(offx);
        this.cameraSettings.setOffsetY(offy);
        Bounds result = this.getBounds(viewMatrix);
        for (InWorldAnnotation highlight : this.inWorldAnnotations) {
            Pair<Vector2f, Vector2f> bounds = highlight.getScreenBounds(viewMatrix);
            result.min().x = Math.min(result.min().x, ((Vector2f)bounds.getLeft()).x);
            result.min().y = Math.min(result.min().y, ((Vector2f)bounds.getLeft()).y);
            result.max().x = Math.max(result.max().x, ((Vector2f)bounds.getRight()).x);
            result.max().y = Math.max(result.max().y, ((Vector2f)bounds.getRight()).y);
        }
        return new Vector4f(result.min().x, result.min().y, result.max().x, result.max().y);
    }

    public void centerScene() {
        Vector4f bounds = this.getScreenBounds();
        float w = -(bounds.z - bounds.x) / 2.0f;
        float h = -(bounds.w - bounds.y) / 2.0f;
        this.cameraSettings.setOffsetX(w - bounds.x);
        this.cameraSettings.setOffsetY(h - bounds.y);
    }

    private Bounds getBounds(Matrix4f viewMatrix) {
        Vector3f tmpPos = new Vector3f();
        Vector3f min = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.level.getFilledBlocks().forEach(pos -> {
            BlockState state = this.level.m_8055_((BlockPos)pos);
            if (!state.m_155947_() && state.m_60799_() == RenderShape.INVISIBLE) {
                return;
            }
            for (int xCorner = 0; xCorner <= 1; ++xCorner) {
                for (int yCorner = 0; yCorner <= 1; ++yCorner) {
                    for (int zCorner = 0; zCorner <= 1; ++zCorner) {
                        viewMatrix.transformPosition((float)(pos.m_123341_() + xCorner), (float)(pos.m_123342_() + yCorner), (float)(pos.m_123343_() + zCorner), tmpPos);
                        min.min((Vector3fc)tmpPos);
                        max.max((Vector3fc)tmpPos);
                    }
                }
            }
        });
        for (Entity entity : this.level.getEntitiesForRendering()) {
            AABB bounds = entity.m_20191_();
            for (int xCorner = 0; xCorner <= 1; ++xCorner) {
                for (int yCorner = 0; yCorner <= 1; ++yCorner) {
                    for (int zCorner = 0; zCorner <= 1; ++zCorner) {
                        viewMatrix.transformPosition((float)(xCorner == 0 ? bounds.f_82288_ : bounds.f_82291_), (float)(yCorner == 0 ? bounds.f_82289_ : bounds.f_82292_), (float)(zCorner == 0 ? bounds.f_82290_ : bounds.f_82293_), tmpPos);
                        min.min((Vector3fc)tmpPos);
                        max.max((Vector3fc)tmpPos);
                    }
                }
            }
        }
        if (!min.isFinite() || !max.isFinite()) {
            return new Bounds(new Vector3f(), new Vector3f());
        }
        return new Bounds(min, max);
    }

    public Vector2f worldToScreen(float x, float y, float z) {
        Matrix4f viewMatrix = this.cameraSettings.getViewMatrix();
        Matrix4f projectionMatrix = this.cameraSettings.getProjectionMatrix();
        Vector3f screenPos = new Vector3f();
        viewMatrix.transformPosition(x, y, z, screenPos);
        projectionMatrix.transformProject(screenPos);
        return new Vector2f(screenPos.x, screenPos.y);
    }

    private static Vector2f worldToScreen(Matrix4f viewMatrix, Matrix4f projectionMatrix, float x, float y, float z) {
        Vector3f screenPos = new Vector3f();
        viewMatrix.transformPosition(x, y, z, screenPos);
        projectionMatrix.transformProject(screenPos);
        return new Vector2f();
    }

    private void buildPickRay(float screenX, float screenY, Vector3f rayOrigin, Vector3f rayDir) {
        Matrix4f viewProj = new Matrix4f((Matrix4fc)this.cameraSettings.getProjectionMatrix());
        viewProj.mul((Matrix4fc)this.cameraSettings.getViewMatrix());
        viewProj.unprojectRay(screenX, screenY, new int[]{-1, -1, 2, 2}, rayOrigin, rayDir);
    }

    @Nullable
    public SceneAnnotation pickAnnotation(LytPoint point, LytRect viewport, Predicate<? super SceneAnnotation> predicate) {
        Vector2f screenPos = this.documentToScreen(viewport, point);
        SceneAnnotation annotation = this.pickOverlayAnnotation(point, viewport, predicate);
        if (annotation == null) {
            annotation = this.pickInWorldAnnotation(screenPos.x, screenPos.y, predicate);
        }
        return annotation;
    }

    @Nullable
    public OverlayAnnotation pickOverlayAnnotation(LytPoint point, LytRect viewport, Predicate<? super OverlayAnnotation> predicate) {
        for (int i = this.overlayAnnotations.size() - 1; i >= 0; --i) {
            LytRect bounds;
            OverlayAnnotation annotation = this.overlayAnnotations.get(i);
            if (!predicate.test(annotation) || !(bounds = annotation.getBoundingRect(this, viewport)).contains(point)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public InWorldAnnotation pickInWorldAnnotation(float screenX, float screenY, Predicate<? super InWorldAnnotation> predicate) {
        Vector3f rayOrigin = new Vector3f();
        Vector3f rayDir = new Vector3f();
        this.buildPickRay(screenX, screenY, rayOrigin, rayDir);
        float pickDistance = Float.POSITIVE_INFINITY;
        InWorldAnnotation pickedBox = null;
        for (InWorldAnnotation highlight : this.inWorldAnnotations) {
            OptionalDouble intersectionDist;
            if (!predicate.test(highlight) || !(intersectionDist = highlight.intersect(rayOrigin, rayDir)).isPresent() || !(intersectionDist.getAsDouble() < (double)pickDistance)) continue;
            pickDistance = (float)intersectionDist.getAsDouble();
            pickedBox = highlight;
        }
        return pickedBox;
    }

    public BlockHitResult pickBlock(LytPoint point, LytRect viewport) {
        Vector2f screenPos = this.documentToScreen(viewport, point);
        Vector3f rayOrigin = new Vector3f();
        Vector3f rayDir = new Vector3f();
        this.buildPickRay(screenPos.x, screenPos.y, rayOrigin, rayDir);
        GuidebookLevel.Bounds levelBounds = this.level.getBounds();
        Vector2f intersection = new Vector2f();
        if (!Intersectionf.intersectRayAab((Vector3fc)rayOrigin, (Vector3fc)rayDir, (Vector3fc)new Vector3f((float)levelBounds.min().m_123341_(), (float)levelBounds.min().m_123342_(), (float)levelBounds.min().m_123343_()), (Vector3fc)new Vector3f((float)levelBounds.max().m_123341_(), (float)levelBounds.max().m_123342_(), (float)levelBounds.max().m_123343_()), (Vector2f)intersection)) {
            return BlockHitResult.m_82426_((Vec3)Vec3.f_82478_, (Direction)Direction.UP, (BlockPos)BlockPos.f_121853_);
        }
        Vector3f start = new Vector3f((Vector3fc)rayDir).mulAdd(intersection.x, (Vector3fc)rayOrigin);
        Vector3f end = new Vector3f((Vector3fc)rayDir).mulAdd(intersection.y, (Vector3fc)rayOrigin);
        Vec3 fromVec3 = new Vec3(start);
        Vec3 toVec3 = new Vec3(end);
        ClipContext.Block blockClipContext = ClipContext.Block.OUTLINE;
        ClipContext.Fluid fluidClipContext = ClipContext.Fluid.ANY;
        return (BlockHitResult)BlockGetter.m_151361_((Vec3)fromVec3, (Vec3)toVec3, null, (ignored, blockPos) -> {
            BlockState blockState = this.level.m_8055_((BlockPos)blockPos);
            FluidState fluidState = this.level.m_6425_((BlockPos)blockPos);
            VoxelShape blockShape = blockClipContext.m_7544_(blockState, (BlockGetter)this.level, blockPos, CollisionContext.m_82749_());
            BlockHitResult blockHit = this.level.m_45558_(fromVec3, toVec3, (BlockPos)blockPos, blockShape, blockState);
            VoxelShape fluidShape = fluidClipContext.m_45731_(fluidState) ? fluidState.m_76183_((BlockGetter)this.level, blockPos) : Shapes.m_83040_();
            BlockHitResult fluidHit = fluidShape.m_83220_(fromVec3, toVec3, blockPos);
            double blockDist = blockHit == null ? Double.MAX_VALUE : fromVec3.m_82557_(blockHit.m_82450_());
            double fluidDist = fluidHit == null ? Double.MAX_VALUE : fromVec3.m_82557_(fluidHit.m_82450_());
            return blockDist <= fluidDist ? blockHit : fluidHit;
        }, ignored -> {
            Vec3 vec3 = fromVec3.m_82546_(toVec3);
            return BlockHitResult.m_82426_((Vec3)toVec3, (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)BlockPos.m_274446_((Position)toVec3));
        });
    }

    public Stream<BlockPos> getFilledBlocks() {
        return this.level.getFilledBlocks();
    }

    public Vector3fc getWorldCenter() {
        Vector3f min = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.level.getFilledBlocks().forEach(pos -> {
            Vector3f tmp = new Vector3f();
            for (int xCorner = 0; xCorner <= 1; ++xCorner) {
                for (int yCorner = 0; yCorner <= 1; ++yCorner) {
                    for (int zCorner = 0; zCorner <= 1; ++zCorner) {
                        tmp.set((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                        min.min((Vector3fc)tmp);
                        max.max((Vector3fc)tmp);
                        tmp.add(1.0f, 1.0f, 1.0f);
                        min.min((Vector3fc)tmp);
                        max.max((Vector3fc)tmp);
                    }
                }
            }
        });
        Vector3f tmp = new Vector3f();
        for (Entity entity : this.level.getEntitiesForRendering()) {
            AABB bounds = entity.m_20191_();
            tmp.set(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_);
            min.min((Vector3fc)tmp);
            tmp.set(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_);
            max.max((Vector3fc)tmp);
        }
        Vector3f avg = new Vector3f((Vector3fc)min);
        avg.add((Vector3fc)max);
        avg.div(2.0f);
        return avg;
    }

    public GuidebookLevel getLevel() {
        return this.level;
    }

    public CameraSettings getCameraSettings() {
        return this.cameraSettings;
    }

    public void clearAnnotations() {
        this.inWorldAnnotations.clear();
        this.overlayAnnotations.clear();
    }

    public void addAnnotation(SceneAnnotation annotation) {
        if (annotation instanceof InWorldAnnotation) {
            InWorldAnnotation inWorldAnnotation = (InWorldAnnotation)annotation;
            this.inWorldAnnotations.add(inWorldAnnotation);
        }
        if (annotation instanceof OverlayAnnotation) {
            OverlayAnnotation overlayAnnotation = (OverlayAnnotation)annotation;
            this.overlayAnnotations.add(overlayAnnotation);
        }
    }

    public void removeAnnotation(SceneAnnotation annotation) {
        if (annotation instanceof InWorldAnnotation) {
            this.inWorldAnnotations.remove(annotation);
        }
        if (annotation instanceof OverlayAnnotation) {
            this.overlayAnnotations.remove(annotation);
        }
    }

    public Collection<InWorldAnnotation> getInWorldAnnotations() {
        return this.inWorldAnnotations;
    }

    public Collection<OverlayAnnotation> getOverlayAnnotations() {
        return this.overlayAnnotations;
    }

    public Vector2f documentToScreen(LytRect viewport, LytPoint documentPoint) {
        float localX = (documentPoint.x() - (float)viewport.x()) / (float)viewport.width() * 2.0f - 1.0f;
        float localY = -((documentPoint.y() - (float)viewport.y()) / (float)viewport.height() * 2.0f - 1.0f);
        return new Vector2f(localX, localY);
    }

    public LytPoint screenToDocument(Vector2f screen, LytRect viewport) {
        float x = (float)viewport.x() + (screen.x + 1.0f) / 2.0f * (float)viewport.width();
        float y = (float)viewport.y() + (-screen.y + 1.0f) / 2.0f * (float)viewport.height();
        return new LytPoint(x, y);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    private record Bounds(Vector3f min, Vector3f max) {
    }
}

