/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.knn;

import guideme.internal.shaded.lucene.search.AbstractKnnCollector;
import guideme.internal.shaded.lucene.search.KnnCollector;
import guideme.internal.shaded.lucene.search.TopDocs;
import guideme.internal.shaded.lucene.util.hnsw.BlockingFloatHeap;
import guideme.internal.shaded.lucene.util.hnsw.FloatHeap;

public final class MultiLeafKnnCollector
implements KnnCollector {
    private static final float DEFAULT_GREEDINESS = 0.9f;
    private final BlockingFloatHeap globalSimilarityQueue;
    private final FloatHeap nonCompetitiveQueue;
    private final float greediness;
    private final FloatHeap updatesQueue;
    private final float[] updatesScratch;
    private final int interval = 255;
    private boolean kResultsCollected = false;
    private float cachedGlobalMinSim = Float.NEGATIVE_INFINITY;
    private final AbstractKnnCollector subCollector;

    public MultiLeafKnnCollector(int k, BlockingFloatHeap globalSimilarityQueue, AbstractKnnCollector subCollector) {
        this.greediness = 0.9f;
        this.subCollector = subCollector;
        this.globalSimilarityQueue = globalSimilarityQueue;
        this.nonCompetitiveQueue = new FloatHeap(Math.max(1, Math.round((1.0f - this.greediness) * (float)k)));
        this.updatesQueue = new FloatHeap(k);
        this.updatesScratch = new float[k];
    }

    @Override
    public boolean earlyTerminated() {
        return this.subCollector.earlyTerminated();
    }

    @Override
    public void incVisitedCount(int count) {
        this.subCollector.incVisitedCount(count);
    }

    @Override
    public long visitedCount() {
        return this.subCollector.visitedCount();
    }

    @Override
    public long visitLimit() {
        return this.subCollector.visitLimit();
    }

    @Override
    public int k() {
        return this.subCollector.k();
    }

    @Override
    public boolean collect(int docId, float similarity) {
        int len;
        boolean firstKResultsCollected;
        boolean localSimUpdated = this.subCollector.collect(docId, similarity);
        boolean bl = firstKResultsCollected = !this.kResultsCollected && this.subCollector.numCollected() == this.k();
        if (firstKResultsCollected) {
            this.kResultsCollected = true;
        }
        this.updatesQueue.offer(similarity);
        boolean globalSimUpdated = this.nonCompetitiveQueue.offer(similarity);
        if (this.kResultsCollected && (firstKResultsCollected || (this.subCollector.visitedCount() & 0xFFL) == 0L) && (len = this.updatesQueue.size()) > 0) {
            for (int i = 0; i < len; ++i) {
                this.updatesScratch[i] = this.updatesQueue.poll();
            }
            assert (this.updatesQueue.size() == 0);
            this.cachedGlobalMinSim = this.globalSimilarityQueue.offer(this.updatesScratch, len);
            globalSimUpdated = true;
        }
        return localSimUpdated || globalSimUpdated;
    }

    @Override
    public float minCompetitiveSimilarity() {
        if (!this.kResultsCollected) {
            return Float.NEGATIVE_INFINITY;
        }
        return Math.max(this.subCollector.minCompetitiveSimilarity(), Math.min(this.nonCompetitiveQueue.peek(), this.cachedGlobalMinSim));
    }

    @Override
    public TopDocs topDocs() {
        return this.subCollector.topDocs();
    }

    public String toString() {
        return "MultiLeafKnnCollector[subCollector=" + this.subCollector + "]";
    }
}

