/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.MultiTermQuery;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.AttributeSource;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import guideme.internal.shaded.lucene.util.automaton.Automaton;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import java.io.IOException;

public class AutomatonQuery
extends MultiTermQuery
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(AutomatonQuery.class);
    protected final Automaton automaton;
    protected final CompiledAutomaton compiled;
    protected final Term term;
    protected final boolean automatonIsBinary;
    private final long ramBytesUsed;

    public AutomatonQuery(Term term, Automaton automaton) {
        this(term, automaton, 10000);
    }

    public AutomatonQuery(Term term, Automaton automaton, int determinizeWorkLimit) {
        this(term, automaton, determinizeWorkLimit, false);
    }

    public AutomatonQuery(Term term, Automaton automaton, int determinizeWorkLimit, boolean isBinary) {
        this(term, automaton, determinizeWorkLimit, isBinary, CONSTANT_SCORE_BLENDED_REWRITE);
    }

    public AutomatonQuery(Term term, Automaton automaton, int determinizeWorkLimit, boolean isBinary, MultiTermQuery.RewriteMethod rewriteMethod) {
        super(term.field(), rewriteMethod);
        this.term = term;
        this.automaton = automaton;
        this.automatonIsBinary = isBinary;
        this.compiled = new CompiledAutomaton(automaton, null, true, determinizeWorkLimit, isBinary);
        this.ramBytesUsed = BASE_RAM_BYTES + term.ramBytesUsed() + automaton.ramBytesUsed() + this.compiled.ramBytesUsed();
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return this.compiled.getTermsEnum(terms);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.compiled.hashCode();
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutomatonQuery other = (AutomatonQuery)obj;
        if (!this.compiled.equals(other.compiled)) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.getClass().getSimpleName());
        buffer.append(" {");
        buffer.append('\n');
        buffer.append(this.automaton.toString());
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            this.compiled.visit(visitor, this, this.field);
        }
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public boolean isAutomatonBinary() {
        return this.automatonIsBinary;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }
}

