/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.flexible.standard.builders;

import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.queryparser.flexible.core.QueryNodeException;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.FuzzyQueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.QueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import guideme.internal.shaded.lucene.search.FuzzyQuery;

public class FuzzyQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public FuzzyQuery build(QueryNode queryNode) throws QueryNodeException {
        FuzzyQueryNode fuzzyNode = (FuzzyQueryNode)queryNode;
        String text = fuzzyNode.getTextAsString();
        int numEdits = FuzzyQuery.floatToEdits(fuzzyNode.getSimilarity(), text.codePointCount(0, text.length()));
        return new FuzzyQuery(new Term(fuzzyNode.getFieldAsString(), fuzzyNode.getTextAsString()), numEdits, fuzzyNode.getPrefixLength());
    }
}

