/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.intervals;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.queries.intervals.IntervalIterator;
import guideme.internal.shaded.lucene.queries.intervals.IntervalMatches;
import guideme.internal.shaded.lucene.queries.intervals.IntervalMatchesIterator;
import guideme.internal.shaded.lucene.queries.intervals.IntervalQuery;
import guideme.internal.shaded.lucene.queries.intervals.IntervalsSource;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import java.io.IOException;

abstract class DifferenceIntervalsSource
extends IntervalsSource {
    final IntervalsSource minuend;
    final IntervalsSource subtrahend;

    DifferenceIntervalsSource(IntervalsSource minuend, IntervalsSource subtrahend) {
        this.minuend = minuend;
        this.subtrahend = subtrahend;
    }

    protected abstract IntervalIterator combine(IntervalIterator var1, IntervalIterator var2);

    @Override
    public final IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        IntervalIterator minIt = this.minuend.intervals(field, ctx);
        if (minIt == null) {
            return null;
        }
        IntervalIterator subIt = this.subtrahend.intervals(field, ctx);
        if (subIt == null) {
            return minIt;
        }
        return this.combine(minIt, subIt);
    }

    @Override
    public final IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        IntervalMatchesIterator minIt = this.minuend.matches(field, ctx, doc);
        if (minIt == null) {
            return null;
        }
        IntervalMatchesIterator subIt = this.subtrahend.matches(field, ctx, doc);
        if (subIt == null) {
            return minIt;
        }
        IntervalIterator difference = this.combine(IntervalMatches.wrapMatches(minIt, doc), IntervalMatches.wrapMatches(subIt, doc));
        return IntervalMatches.asMatches(difference, minIt, doc);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        IntervalQuery q = new IntervalQuery(field, this);
        this.minuend.visit(field, visitor.getSubVisitor(BooleanClause.Occur.MUST, q));
        this.subtrahend.visit(field, visitor.getSubVisitor(BooleanClause.Occur.MUST_NOT, q));
    }

    @Override
    public int minExtent() {
        return this.minuend.minExtent();
    }
}

