/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.IndexOptions;
import guideme.internal.shaded.lucene.index.IndexWriter;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.util.InfoStream;
import java.io.IOException;

public class SimpleMergedSegmentWarmer
implements IndexWriter.IndexReaderWarmer {
    private final InfoStream infoStream;

    public SimpleMergedSegmentWarmer(InfoStream infoStream) {
        this.infoStream = infoStream;
    }

    @Override
    public void warm(LeafReader reader) throws IOException {
        long startTime = System.currentTimeMillis();
        int indexedCount = 0;
        int docValuesCount = 0;
        int normsCount = 0;
        for (FieldInfo info : reader.getFieldInfos()) {
            if (info.getIndexOptions() != IndexOptions.NONE) {
                reader.terms(info.name);
                ++indexedCount;
                if (info.hasNorms()) {
                    reader.getNormValues(info.name);
                    ++normsCount;
                }
            }
            if (info.getDocValuesType() == DocValuesType.NONE) continue;
            switch (info.getDocValuesType()) {
                case NUMERIC: {
                    reader.getNumericDocValues(info.name);
                    break;
                }
                case BINARY: {
                    reader.getBinaryDocValues(info.name);
                    break;
                }
                case SORTED: {
                    reader.getSortedDocValues(info.name);
                    break;
                }
                case SORTED_NUMERIC: {
                    reader.getSortedNumericDocValues(info.name);
                    break;
                }
                case SORTED_SET: {
                    reader.getSortedSetDocValues(info.name);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ++docValuesCount;
        }
        reader.storedFields().document(0);
        reader.termVectors().get(0);
        if (this.infoStream.isEnabled("SMSW")) {
            this.infoStream.message("SMSW", "Finished warming segment: " + reader + ", indexed=" + indexedCount + ", docValues=" + docValuesCount + ", norms=" + normsCount + ", time=" + (System.currentTimeMillis() - startTime));
        }
    }
}

