/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.MergePolicy;
import guideme.internal.shaded.lucene.index.MergeTrigger;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.util.InfoStream;
import guideme.internal.shaded.lucene.util.SameThreadExecutorService;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public abstract class MergeScheduler
implements Closeable {
    private final ExecutorService executor = new SameThreadExecutorService();
    protected InfoStream infoStream;

    protected MergeScheduler() {
    }

    public abstract void merge(MergeSource var1, MergeTrigger var2) throws IOException;

    public Directory wrapForMerge(MergePolicy.OneMerge merge, Directory in) {
        return in;
    }

    public Executor getIntraMergeExecutor(MergePolicy.OneMerge merge) {
        return this.executor;
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
    }

    void initialize(InfoStream infoStream, Directory directory) throws IOException {
        this.infoStream = infoStream;
    }

    protected boolean verbose() {
        return this.infoStream != null && this.infoStream.isEnabled("MS");
    }

    protected void message(String message) {
        this.infoStream.message("MS", message);
    }

    public static interface MergeSource {
        public MergePolicy.OneMerge getNextMerge();

        public void onMergeFinished(MergePolicy.OneMerge var1);

        public boolean hasPendingMerges();

        public void merge(MergePolicy.OneMerge var1) throws IOException;
    }
}

