/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.synonym.word2vec;

import guideme.internal.shaded.lucene.analysis.synonym.word2vec.TermAndBoost;
import guideme.internal.shaded.lucene.analysis.synonym.word2vec.Word2VecModel;
import guideme.internal.shaded.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import guideme.internal.shaded.lucene.index.VectorSimilarityFunction;
import guideme.internal.shaded.lucene.search.KnnCollector;
import guideme.internal.shaded.lucene.search.TopDocs;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraphBuilder;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraphSearcher;
import guideme.internal.shaded.lucene.util.hnsw.OnHeapHnswGraph;
import guideme.internal.shaded.lucene.util.hnsw.RandomAccessVectorValues;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorer;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorerSupplier;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class Word2VecSynonymProvider {
    private static final VectorSimilarityFunction SIMILARITY_FUNCTION = VectorSimilarityFunction.DOT_PRODUCT;
    private final Word2VecModel word2VecModel;
    private final OnHeapHnswGraph hnswGraph;
    private final DefaultFlatVectorScorer defaultFlatVectorScorer = new DefaultFlatVectorScorer();

    public Word2VecSynonymProvider(Word2VecModel model) throws IOException {
        this.word2VecModel = model;
        RandomVectorScorerSupplier scorerSupplier = this.defaultFlatVectorScorer.getRandomVectorScorerSupplier(SIMILARITY_FUNCTION, this.word2VecModel);
        HnswGraphBuilder builder = HnswGraphBuilder.create(scorerSupplier, 16, 100, HnswGraphBuilder.randSeed, this.word2VecModel.size());
        this.hnswGraph = builder.build(this.word2VecModel.size());
    }

    public List<TermAndBoost> getSynonyms(BytesRef term, int maxSynonymsPerTerm, float minAcceptedSimilarity) throws IOException {
        if (term == null) {
            throw new IllegalArgumentException("Term must not be null");
        }
        LinkedList<TermAndBoost> result = new LinkedList<TermAndBoost>();
        float[] query = this.word2VecModel.vectorValue(term);
        if (query != null) {
            RandomVectorScorer scorer = this.defaultFlatVectorScorer.getRandomVectorScorer(SIMILARITY_FUNCTION, (RandomAccessVectorValues)this.word2VecModel, query);
            KnnCollector synonyms = HnswGraphSearcher.search(scorer, maxSynonymsPerTerm + 1, this.hnswGraph, null, Integer.MAX_VALUE);
            TopDocs topDocs = synonyms.topDocs();
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                float similarity = topDocs.scoreDocs[i].score;
                int id = topDocs.scoreDocs[i].doc;
                BytesRef synonym = this.word2VecModel.termValue(id);
                if (synonym.equals(term) || !(similarity >= minAcceptedSimilarity)) continue;
                result.addLast(new TermAndBoost(synonym, similarity));
            }
        }
        return result;
    }
}

