/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.hunspell;

import guideme.internal.shaded.lucene.util.ArrayUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class FlagEnumerator {
    private final StringBuilder builder = new StringBuilder();
    private final Map<String, Integer> indices = new HashMap<String, Integer>();

    FlagEnumerator() {
        this.add(new char[0]);
    }

    int add(char[] chars) {
        Arrays.sort(chars);
        String key = new String(chars);
        if (key.length() > 65535) {
            throw new IllegalArgumentException("Too many flags: " + key);
        }
        Integer existing = this.indices.get(key);
        if (existing != null) {
            return existing;
        }
        int result = this.builder.length();
        this.indices.put(key, result);
        this.builder.append((char)key.length());
        this.builder.append(key);
        return result;
    }

    Lookup finish() {
        char[] result = new char[this.builder.length()];
        this.builder.getChars(0, this.builder.length(), result, 0);
        return new Lookup(result);
    }

    static boolean hasFlagInSortedArray(char flag, char[] array, int start, int length) {
        if (flag == '\u0000') {
            return false;
        }
        for (int i = start; i < start + length; ++i) {
            char c = array[i];
            if (c == flag) {
                return true;
            }
            if (c <= flag) continue;
            return false;
        }
        return false;
    }

    static class Lookup {
        private final char[] data;

        private Lookup(char[] data) {
            this.data = data;
        }

        boolean hasFlag(int entryId, char flag) {
            return entryId >= 0 && FlagEnumerator.hasFlagInSortedArray(flag, this.data, entryId + 1, this.data[entryId]);
        }

        boolean hasAnyFlag(int entryId, char[] sortedFlags) {
            char length = this.data[entryId];
            if (length == '\u0000') {
                return false;
            }
            int pos1 = entryId + 1;
            int limit1 = entryId + 1 + length;
            int pos2 = 0;
            int limit2 = sortedFlags.length;
            char c1 = this.data[pos1];
            char c2 = sortedFlags[pos2];
            while (c1 != c2) {
                if (c1 < c2) {
                    if (++pos1 >= limit1) {
                        return false;
                    }
                    c1 = this.data[pos1];
                    continue;
                }
                if (++pos2 >= limit2) {
                    return false;
                }
                c2 = sortedFlags[pos2];
            }
            return true;
        }

        char[] getFlags(int entryId) {
            return ArrayUtil.copyOfSubArray(this.data, entryId + 1, entryId + 1 + this.data[entryId]);
        }
    }
}

